#include <errno.h>
#include <glib.h>

#include "edv_types.h"
#include "edv_vfs_obj.h"
#include "edv_recycled_obj.h"
#include "edv_recycle_bin_index.h"
#include "edv_recycled_obj_stat.h"


EDVRecycledObject *edv_recycled_object_stat(
	const gchar *index_path,
	const gulong index
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Gets the statistics of the recycled object in the recycle bin.
 *
 *	The index_path specifies the full path to the recycle bin index
 *	file.
 *
 *	The index specifies the index of recycled object who stats are
 *	to be obtained.
 *
 *	Returns a dynamically allocated recycled object containing the
 *	statistics of the recycled object or NULL on error.
 */
EDVRecycledObject *edv_recycled_object_stat(
	const gchar *index_path,
	const gulong index
)
{
	EDVRecycleBinIndex *rp = edv_recycle_bin_index_open(index_path);
	EDVRecycledObject *obj = edv_recycle_bin_index_seek(
		rp,
		index
	);
	if(obj != NULL)
		obj = edv_recycled_object_copy(obj);
	edv_recycle_bin_index_close(rp);

	return(obj);
}
