/*
	       Endeavour Mark II API - Recycled Object
 */

#ifndef EDV_RECYCLED_OBJ_H
#define EDV_RECYCLED_OBJ_H

#include <glib.h>
#include "edv_types.h"


typedef struct _EDVRecycledObject	EDVRecycledObject;
#define EDV_RECYCLED_OBJECT(p)		((EDVRecycledObject *)(p))


/*
 *	Recycled Object:
 */
struct _EDVRecycledObject {

	/* Type */
	EDVObjectType	type;

	/* Recycle bin index number, a unique identifier used to
	 * reference this recycled object
	 */
	gulong		index;

	/* Original name of object */
	gchar		*name;

	/* Full path to the original location without the name */
	gchar		*original_path;

	/* Sizes (in bytes) */
	gulong		size,			/* Original size */
			storage_size;		/* Size object consumes in
						 * Recycle Bin */

	/* Link (only for EDV_OBJECT_TYPE_LINK) )*/
	gchar		*link_target;

	/* Permissions */
	EDVPermissionFlags permissions;

	/* Time Stamps (in seconds since EPOCH) */
	gulong		access_time,
			modify_time,
			change_time,
			deleted_time;

	/* Ownership */
	gint		owner_id,
			group_id;

	/* Meta Data List */
	GList		*meta_data_list;	/* GList of EDVProperty *
						 * properties */

};


/*
 *	Creates a new EDVRecycledObject.
 *
 *	Returns a new dynamically allocated EDVRecycledObject with all of its
 *	values zero'ed or NULL on error.
 */
extern EDVRecycledObject *edv_recycled_object_new(void);

/*
 *	Creates a new EDVRecycledObject of a specific type.
 *
 *	The type specifies the EDVRecycledObject's type.
 *
 *	Returns a new dynamically allocated EDVRecycledObject with its
 *	type value set or NULL on error.
 */
extern EDVRecycledObject *edv_recycled_object_new_type(const EDVObjectType type);

/*
 *	Coppies the EDVRecycledObject.
 *
 *	The obj specifies the EDVRecycledObject to copy.
 *
 *	Returns a new dynamically allocated copy of the
 *	EDVRecycledObject or NULL on error.
 */
extern EDVRecycledObject *edv_recycled_object_copy(EDVRecycledObject *obj);

/*
 *	Sets the EDVRecycledObject's values from another EDVRecycledObject.
 *
 *	The obj specifies the EDVRecycledObject to be set.
 *
 *	The obj_values specifies the values to set obj with.
 */
extern void edv_recycled_object_set_object(
	EDVRecycledObject *obj,
	EDVRecycledObject *obj_values
);

/*
 *	Deletes and zeros all the values on the EDVRecycledObject.
 *
 *	The obj specifies the EDVRecycledObject who's values are to be
 *	cleared.
 */
extern void edv_recycled_object_clear(EDVRecycledObject *obj);

/*
 *	Deletes the EDVRecycledObject.
 *
 *	The obj specifies the EDVRecycledObject to delete.
 */
extern void edv_recycled_object_delete(EDVRecycledObject *obj);


#endif	/* EDV_RECYCLED_OBJ_H */
