#include <errno.h>
#include <glib.h>

#include "edv_property.h"
#include "edv_property_image.h"


GList *edv_properties_list_image_set(
	GList *properties_list,
	const gint width, const gint height,
	const gint nframes,
	const gulong play_time_ms,
	const gchar *creator,
	const gchar *author,
	const gchar *title,
	const gchar *comments,
	const gchar *last_modified_sec_str
);
GList *edv_properties_list_image_remove(GList *properties_list); 


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


GList *edv_properties_list_image_set(
	GList *properties_list,
	const gint width, const gint height,
	const gint nframes,
	const gulong play_time_ms,
	const gchar *creator,
	const gchar *author,
	const gchar *title,
	const gchar *comments,
	const gchar *last_modified_sec_str
)
{
#define ADD_PROP(_p_,_v_)	{			\
 properties_list = edv_properties_list_set_s(		\
  properties_list,					\
  (_p_), (_v_),						\
  TRUE				/* Create as needed */	\
 );							\
}
#define REMOVE_PROP(_p_)	{			\
 properties_list = edv_properties_list_remove(		\
  properties_list,					\
  (_p_)							\
 );							\
}

	if(width > 0)
	{
	    gchar *s = g_strdup_printf("%i", width);
	    ADD_PROP("Image Width", s);
	    g_free(s);
	}
	else
	{
	    REMOVE_PROP("Image Width");
	}

	if(height > 0)
	{
	    gchar *s = g_strdup_printf("%i", height);
	    ADD_PROP("Image Height", s);
	    g_free(s);
	}
	else
	{
	    REMOVE_PROP("Image Height");
	}

	if(nframes > 0)
	{
	    gchar *s = g_strdup_printf("%i", nframes);
	    ADD_PROP("Image Frames", s);
	    g_free(s);
	}
	else
	{
	    REMOVE_PROP("Image Frames");
	}

	if(play_time_ms > 0l)
	{
	    gchar *s = g_strdup_printf("%.2f seconds", (gfloat)play_time_ms / 1000.0f);
	    ADD_PROP("Image Play Time", s);
	    g_free(s);
	}
	else
	{
	    REMOVE_PROP("Image Play Time");
	}

	if(STRISEMPTY(creator))
	{
	    REMOVE_PROP("Image Creator");
	}
	else
	{
	    ADD_PROP("Image Creator", creator);
	}

	if(STRISEMPTY(author))
	{
	    REMOVE_PROP("Image Author");
	}
	else
	{
	    ADD_PROP("Image Author", author);
	}

	if(STRISEMPTY(title))
	{
	    REMOVE_PROP("Image Title");
	}
	else
	{
	    ADD_PROP("Image Title", title);
	}

	if(STRISEMPTY(comments))
	{
	    REMOVE_PROP("Image Comments");
	}
	else
	{
	    ADD_PROP("Image Comments", comments);
	}

	if(STRISEMPTY(last_modified_sec_str))
	{
	    REMOVE_PROP("Image Last Modified");
	}
	else
	{
	    ADD_PROP("Image Last Modified", last_modified_sec_str);
	}

#undef ADD_PROP
#undef REMOVE_PROP

	return(properties_list);
}

GList *edv_properties_list_image_remove(GList *properties_list)
{
	return(edv_properties_list_image_set(
	    properties_list,
	    0, 0,
	    0,
	    0l,
	    NULL, NULL, NULL, NULL,
	    NULL
	));
}
