/*
		   Endeavour Mark II - Property File IO

	Endeavour Mark II property files are text files that contain
	none, one, or multiple sections with properties.

	Each section is denoted with a heading encased in '[' and ']'
	characters on a single line, example:

	[my section]

	Each property contains a parameter and a value separated by
	a '=' character on a single line, example:

	myparameter = my value 12345

	Notice that the parameter may not contain spaces but the value
	can.

	Escape sequences are allowed and will be parsed.

	Newlines can also be escaped, and as such will be loaded as one
	complete continuous line, example:

	myparameter = my very long value\
	continues here\
	ane ends here.

 */

#ifndef EDV_PROPERTY_FIO_H
#define EDV_PROPERTY_FIO_H

#include <stdio.h>
#include <glib.h>
#include "edv_property.h"


/* Get */
extern gchar *edv_properties_list_stream_get_s(
	FILE *fp,
	const gchar *section,
	const gchar *name
);
extern gchar *edv_properties_list_file_get_s(
	const gchar *path,
	const gchar *section,
	const gchar *name
);
extern GList *edv_properties_list_stream_get_list(
	FILE *fp,
	const gchar *section,
	const gchar *name_filter
);
extern GList *edv_properties_list_file_get_list(
	const gchar *path,
	const gchar *section,
	const gchar *name_filter
);

/* Set */
extern gint edv_properties_list_stream_set_s(
	FILE *in_fp,
	FILE *out_fp,
	const gchar *section,
	const gchar *name,
	const gchar *value
);
extern gint edv_properties_list_file_set_s(
	const gchar *path,
	const gchar *section,
	const gchar *name,
	const gchar *value
);

/* Remove */
extern gint edv_properties_list_stream_remove(
	FILE *in_fp,
	FILE *out_fp,
	const gchar *section,
	const gchar *name
);
extern gint edv_properties_list_file_remove(
	const gchar *path,
	const gchar *section,
	const gchar *name
);

extern gint edv_properties_list_stream_remove_section(
        FILE *in_fp,
        FILE *out_fp,
        const gchar *section
);
extern gint edv_properties_list_file_remove_section(
        const gchar *path,
        const gchar *section
);

/* Clean */
extern void edv_properties_list_stream_clean(
	FILE *in_fp,
	FILE *out_fp,
	const gboolean remove_empty_sections,
	const gboolean remove_comments,
	const gboolean remove_empty_lines
);
extern void edv_properties_list_file_clean(
	const gchar *path,
	const gboolean remove_empty_sections,
	const gboolean remove_comments,
	const gboolean remove_empty_lines
);


#endif	/* EDV_PROPERTY_FIO_H */
