/*
		      Endeavour Mark II - Property

	Used on the VFS, Recycled and Archive object structures to
	hold non-standard properties.

	See also: edv_archive_obj.c edv_property_fio.c
	edv_property_fio.c edv_recycled_obj.c edv_vfs_obj.c
 */

#ifndef EDV_PROPERTY_H
#define EDV_PROPERTY_H

#include <glib.h>

typedef struct _EDVProperty		EDVProperty;
#define EDV_PROPERTY(p)			((EDVProperty *)(p))


/*
 *	Standard Property Names:
 */
#define EDV_PROP_NAME_TYPE		"type"	/* EDVObjectType */
#define EDV_PROP_NAME_DEVICE_INDEX	"device_index"	/* gulong */
#define EDV_PROP_NAME_INDEX		"index"	/* gulong */
#define EDV_PROP_NAME_NAME		"name"	/* gchar * */
#define EDV_PROP_NAME_PATH		"path"	/* gchar * full path for
						 * EDVVFSObjects and full or
						 * relative path for
						 * EDVArchiveObjects */
#define EDV_PROP_NAME_ORIGINAL_PATH	"original_path"	/* gchar * full path to
						 * the original location
						 * without the name */
#define EDV_PROP_NAME_SIZE		"size"	/* gulong in bytes */
#define EDV_PROP_NAME_STORAGE_SIZE	"storage_size"	/* gulong in bytes
							 * for EDVRecycledObjects
							 * and EDVArchiveObjects */
#define EDV_PROP_NAME_LINK_TARGET	"link_target"	/* gchar * */
#define EDV_PROP_NAME_LINK_HINT_FLAGS	"link_hint_flags"	\
						/* gint */
#define EDV_PROP_NAME_PERMISSIONS	"permissions"	/* EDVPermissionFlags */
#define EDV_PROP_NAME_ACCESS_TIME	"access_time"	/* gulong last access
							 * time in seconds
							 * since EPOCH */
#define EDV_PROP_NAME_MODIFY_TIME	"modify_time"	/* gulong last modify
							 * time in seconds
							 * since EPOCH */
#define EDV_PROP_NAME_CHANGE_TIME	"change_time"	/* gulong last change
							 * time in seconds
							 * since EPOCH */
#define EDV_PROP_NAME_DELETED_TIME	"deleted_time"	/* gulong time the
							 * EDVRecycledObject
							 * was deleted in
							 * seconds since EPOCH */
#define EDV_PROP_NAME_OWNER_ID		"owner_id"	/* gint */
#define EDV_PROP_NAME_OWNER_NAME	"owner_name"	/* gchar * original
							 * owner name for
							 * EDVArchiveObjects */
#define EDV_PROP_NAME_GROUP_ID		"group_id"	/* gint */
#define EDV_PROP_NAME_GROUP_NAME	"group_name"	/* gchar * original
							 * group name for
							 * EDVArchiveObjects */
#define EDV_PROP_NAME_DEVICE_TYPE	"device_type"	/* gint device numbers,
							 * major and minor */
#define EDV_PROP_NAME_BLOCK_SIZE	"block_size"	/* gulong IO size in
							 * bytes */
#define EDV_PROP_NAME_BLOCKS		"blocks"	/* gulong blocks
							 * allocated */
#define EDV_PROP_NAME_HARD_LINKS	"hard_links"	/* gint */
#define EDV_PROP_NAME_ENCRYPTION_NAME	"encryption_name"	\
						/* gchar * name of the
						 * encrption for
						 * EDVArchiveObjects */
#define EDV_PROP_NAME_COMPRESSION_RATIO	"compression_ratio"	\
						/* 0.0 to 1.0 */
#define EDV_PROP_NAME_STORAGE_METHOD	"storage_method"	\
						/* gchar * name of the storage
						 * method for EDVArchiveObjects */
#define EDV_PROP_NAME_CRC		"crc"	/* gchar * of the CRC */


/*
 *	Endeavour Mark II Property Names:
 */
#define EDV_PROP_NAME_ERROR		"Error"

#define EDV_PROP_NAME_ICON_FILE_SMALL	"IconFileSmall"
#define EDV_PROP_NAME_ICON_FILE_MEDIUM	"IconFileMedium"
#define EDV_PROP_NAME_ICON_FILE_LARGE	"IconFileLarge"
#define EDV_PROP_NAME_ICON_OPENED_FILE_SMALL	\
					"IconOpenedFileSmall"
#define EDV_PROP_NAME_ICON_OPENED_FILE_MEDIUM	\
					"IconOpenedFileMedium"
#define EDV_PROP_NAME_ICON_OPENED_FILE_LARGE	\
					"IconOpenedFileLarge"


/*
 *	Property:
 */
struct _EDVProperty {

	gchar	*name,
		*value;

};


/* Object Property */
extern EDVProperty *edv_property_new(void);
extern EDVProperty *edv_property_copy(EDVProperty *prop);
extern void edv_property_delete(EDVProperty *prop);

/* Object Properties List */
extern GList *edv_properties_list_set_s(
	GList *properties_list,
	const gchar *name,
	const gchar *value,
	const gboolean create_as_needed
);
extern GList *edv_properties_list_set_i(
	GList *properties_list,
	const gchar *name,
	const gint value,
	const gboolean create_as_needed
);
extern GList *edv_properties_list_set_ul(
	GList *properties_list,
	const gchar *name,
	const gulong value,
	const gboolean create_as_needed
);
extern GList *edv_properties_list_set_f(
	GList *properties_list,
	const gchar *name,
	const gfloat value,
	const gboolean create_as_needed
);
extern GList *edv_properties_list_update(
        GList *properties_list,
        GList *updated_properties_list,
        const gboolean create_as_needed,
        const gboolean remove_non_existant
);
extern GList *edv_properties_list_remove(
	GList *properties_list,
	const gchar *name
);
extern EDVProperty *edv_properties_list_get(
	GList *properties_list,
	const gchar *name
);
extern const gchar *edv_properties_list_get_s(
	GList *properties_list,
	const gchar *name
);
extern gint edv_properties_list_get_i(
	GList *properties_list,
	const gchar *name
);
extern gulong edv_properties_list_get_ul(
	GList *properties_list,
	const gchar *name
);
extern gfloat edv_properties_list_get_f(
	GList *properties_list,
	const gchar *name
);

extern GList *edv_properties_list_copy(GList *properties_list);
extern GList *edv_properties_list_delete(GList *properties_list);


#endif	/* EDV_PROPERTY_H */
