/*
                 Endeavour Mark II API - Event Notification

	Queues/sends InterPS commands.

	Functions edv_notify_queue_*() will queue InterPS commands.
	They require that you call edv_context_flush() or
	edv_context_sync() when you are ready to actually send them.

	Functions edv_notify_*() will queue and send the InterPS
	command.

	Functions edv_notify_queue_vfs_object_*() notify Endeavour
	of when a VFS object has been added, modified, removed,
	mounted, or unmounted.

	Functions edv_notify_queue_recycled_object_*() notify
	Endeavour of when a recycled object has been added, modified,
	or removed.
 */

#ifndef EDV_NOTIFY_H
#define EDV_NOTIFY_H

#include "edv_context.h"


/*
 *	Queues a VFS object added signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the object that was
 *	added.
 */
extern void edv_notify_queue_vfs_object_added(
	EDVContext *ctx,
	const gchar *path
);

/*
 *	Queues a VFS object modified signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the object that was
 *	modified (it may not exist in cases of renaming or moving).
 *
 *	The new_path specifies the full path to the new path of the
 *	modified object. If new_path is NULL then only path will be
 *	sent (hinting that the name of the object was not modified).
 */
extern void edv_notify_queue_vfs_object_modified(
	EDVContext *ctx,
	const gchar *path,
	const gchar *new_path
);

/*
 *	Queues a VFS object removed signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the object that was
 *	removed.
 */
extern void edv_notify_queue_vfs_object_removed(
	EDVContext *ctx,
	const gchar *path
);


/*
 *	Queues a VFS object mounted signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the mount path.
 */
extern void edv_notify_queue_vfs_object_mounted(
	EDVContext *ctx,
	const gchar *path
);

/*
 *	Queues a VFS object unmounted signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the mount path.
 */
extern void edv_notify_queue_vfs_object_unmounted(
	EDVContext *ctx,
	const gchar *path
);


/*
 *	Queues a recycled object added signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The index specifies the index of the recycled object.
 */
extern void edv_notify_queue_recycled_object_added(
	EDVContext *ctx,
	const gulong index
);

/*
 *	Queues a recycled object modified signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The index specifies the index of the recycled object.
 */
extern void edv_notify_queue_recycled_object_modified(
	EDVContext *ctx,
	const gulong index
);

/*
 *	Queues a recycled object removed signal.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The index specifies the index of the recycled object.
 */
extern void edv_notify_queue_recycled_object_removed(
	EDVContext *ctx,
	const gulong index
);


/*
 *	Queues a reconfigured signal.
 *
 *	The reconfigured signal notifies Endeavour when its
 *	configuration has changed.
 *
 *	The ctx specifies the Endeavour 2 Context.
 */
extern void edv_notify_queue_reconfigured(EDVContext *ctx);


#endif	/* EDV_NOTIFY_H */
