/*
             Endeavour Mark II API - MIME Types List File IO
 */

#ifndef EDV_MIME_TYPES_LIST_H
#define EDV_MIME_TYPES_LIST_H

#include <glib.h>
#include "edv_mime_type.h"


/*
 *	Opens the MIME Types List from the MIME Types List file.
 *
 *	The mime_types_list specifies the MIME Types List, a GList of
 *	EDVMIMEType * MIME Types. The MIME Types opened from
 *	the MIME Types List file will be appended to the MIME Types
 *	List.
 *
 *	The path specifies the MIME Types List file.
 *
 *	Returns a GList of EDVMIMEType * MIME Types.
 */
extern GList *edv_mime_types_list_file_open(
	GList *mime_types_list,
	const gchar *path
);


#endif	/* EDV_MIME_TYPES_LIST_H */
