/*
               Endeavour Mark II API - MIME Type Fetching
 */

#ifndef EDV_MIME_TYPE_GET_H
#define EDV_MIME_TYPE_GET_H

#include <glib.h>
#include "edv_property.h"
#include "edv_mime_type.h"
#include "edv_context.h"


/*
 *	Gets the MIME Types list.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	Returns a GList of EDVMIMEType * MIME Types. The
 *	returned list must not be modified or deleted.
 */
extern GList *edv_mime_types_list(EDVContext *ctx);


/*
 *	Matches the MIME Type for a VFS object by path.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the VFS object.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern EDVMIMEType *edv_mime_types_list_match_vfs_object_path(
	EDVContext *ctx,
	const gchar *path
);

/*
 *	Matches the MIME Type for an object described by a properties
 *	list.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The properties list specifies the object's properties, a GList
 *	of EDVProperty * properties.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern EDVMIMEType *edv_mime_types_list_match_properties_list(
	EDVContext *ctx,
	GList *properties_list
);

/*
 *	Matches the MIME Type by type string.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The type specifies the type string.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern EDVMIMEType *edv_mime_types_list_match_type(
	EDVContext *ctx,
	const gchar *type
);


#endif	/* EDV_MIME_TYPE_GET_H */
