/*
                  Endeavour Mark II API - Message Output

	Calls the message dialog to display a message.
 */

#ifndef EDV_MESSAGE_H
#define EDV_MESSAGE_H

#include "edv_context.h"


/*
 *	Displays the message in a dialog.
 *
 *	All calls are nonblocking and thus return immediately.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If title is not NULL then it specifies the title that will be
 *	displayed on the dialog's title bar.
 *
 *	The message specifies the message to be displayed in the
 *	dialog. The message may contain newline characters and will
 *	be displayed accordingly.
 *
 *	If details is not NULL then details specifies additional
 *	messages to be displayed when the help button is clicked on
 *	the dialog. The details may contain newline characters and
 *	will be displayed accordingly.
 *
 */
extern void edv_message(
	EDVContext *ctx,
	const gchar *message
);
extern void edv_message_info(
	EDVContext *ctx,
	const gchar *title,
	const gchar *message,
	const gchar *details
);
extern void edv_message_warning(
	EDVContext *ctx,
	const gchar *title,
	const gchar *message,
	const gchar *details
);
extern void edv_message_error(
	EDVContext *ctx,
	const gchar *title,
	const gchar *message,
	const gchar *details
);


#endif	/* EDV_MESSAGE_H */
