/*
                   Endeavour Mark II API - Low-Level Link

	Low-level link creating, get, set, and check.

	See also: edv_directory.h edv_path.h edv_utils.h
 */

#ifndef EDV_LINK_H
#define EDV_LINK_H

#include <glib.h>


/*
 *	Creates a new link or sets the target value of an existing link.
 *
 *	The path specifies the path to the new link. If the object
 *	exists and is a link then its target value will be updated.
 *	If the object exists but is not a link then -1 will be returned
 *	and errno will be set to EEXIST.
 *
 *	The target specifies the link's target value, which may be      
 *	NULL for no value.
 *
 *	Returns 0 on success or non-zero on error.
 */
extern gint edv_link_create(
        const gchar *path,
        const gchar *target
);


/*
 *	Gets the link's target value.
 *
 *	The path specifies the path to the link.
 *
 *	Returns a dynamically allocated string describing the link's
 *	target value or NULL on error.
 */
extern gchar *edv_link_get_target(const gchar *path);

/*
 *	Gets the link's target value as a full path.
 *
 *	The path specifies the path to the link. The path must be a
 *	full path since its parent path will be used to derive the
 *	target value describing the full path.
 *
 *	Returns a dynamically allocated string describing the link's
 *	target value as a full path or NULL on error.
 */
extern gchar *edv_link_get_target_full(const gchar *path);


/*
 *	Checks if the link has a target value that may possibly be
 *	infinately recursive.
 *
 *	The path specifies the path to the link.
 *
 *	Returns TRUE if the link's target value may be infinatly
 *	recursive.
 */
extern gboolean edv_link_is_infinately_recursive(const gchar *path);


#endif	/* EDV_LINK_H */
