/*
                   Endeavour Mark II API - Low-Level InterPS

	Low-level InterPS (InterProcess) handling available to both
	Endeavour Mark II and the API library.
 */

#ifndef EDV_INTERPS_H
#define EDV_INTERPS_H

#include <glib.h>
#include "cfg.h"


/* InterPS Lock */
extern gint edv_interps_get_lock(const CfgList *cfg_list);
extern gint edv_interps_make_lock(
	const CfgList *cfg_list,
	const gint pid,
	const gboolean force
);
extern void edv_interps_remove_lock(const CfgList *cfg_list);

/* InterPS Commands */
extern void edv_interps_send_command_notify(
	const CfgList *cfg_list,
	const gint pid
);
extern gboolean edv_interps_command_pending(const CfgList *cfg_list);
extern void edv_interps_send_commands(
	const CfgList *cfg_list,
	const gint pid,
	const gchar **cmd_list
);
extern gchar **edv_interps_get_commands(const CfgList *cfg_list);
extern void edv_interps_remove_commands(const CfgList *cfg_list);


#endif	/* EDV_INTERPS_H */
