/*
		Endeavour Mark II API - User & Group ID Fetching
 */

#ifndef EDV_ID_GET_H
#define EDV_ID_GET_H

#include <glib.h>
#include "edv_id.h"
#include "edv_context.h"


/*
 *	Gets the UIDs list.
 *
 *	Returns a GList of EDVUID * which must not be modified
 *	or deleted.
 */
extern GList *edv_uids_list(EDVContext *ctx);

/*
 *	Gets the UID by user ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The user_id specifies the user ID.
 *
 *	Returns the UID which must not be modified or deleted or NULL
 *	on error.
 */
extern EDVUID *edv_uids_list_match_uid(
	EDVContext *ctx,
	const gint user_id
);

/*
 *	Gets the UID by group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns the UID which must not be modified or deleted or NULL
 *	on error.
 */
extern EDVUID *edv_uids_list_match_gid(
	EDVContext *ctx,
	const gint group_id
);

/*
 *	Gets the user ID from the user name.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The user_name specifies the string describing the user name.
 *
 *	Returns the user ID or negative on error.
 */
extern gint edv_uid_name_to_uid(
	EDVContext *ctx,
	const gchar *user_name
);

/*
 *	Gets the user name or a string describing the user ID from the
 *	user ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The user_id specifies the user ID.
 *
 *	Returns a dynamically allocated string describing the user name
 *	or user ID or NULL on error. The calling function must delete
 *	the returned string.
 */
extern gchar *edv_uid_uid_to_name(
	EDVContext *ctx,
	const gint user_id
);

/*
 *	Gets the user name or a string describing the user ID from the
 *	group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns a dynamically allocated string describing the user name
 *	or user ID or NULL on error. The calling function must delete
 *	the returned string.
 */
extern gchar *edv_uid_gid_to_name(
	EDVContext *ctx,
	const gint group_id
);


/*
 *	Gets the GIDs list.
 *
 *	Returns a GList of EDVGID * which must not be modified
 *	or deleted.
 */
extern GList *edv_gids_list(EDVContext *ctx);

/*
 *	Gets the GID by group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns the GID which must not be modified or deleted or NULL
 *	on error.
 */
extern EDVGID *edv_gids_list_match_gid(
	EDVContext *ctx,
	const gint group_id
);

/*
 *	Gets the group ID from the group name.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_name specifies the string describing the group name.
 *
 *	Returns the user ID or negative on error.
 */
extern gint edv_gid_name_to_gid(
	EDVContext *ctx,
	const gchar *group_name
);

/*
 *	Gets the group name or a string describing the group ID from
 *	the group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns a dynamically allocated string describing the group
 *	name or group ID or NULL on error or NULL on error. The
 *	calling function must delete the returned string.
 */
extern gchar *edv_gid_gid_to_name(
	EDVContext *ctx,
	const gint group_id
);


#endif	/* EDV_ID_GET_H */
