/*
                  Endeavour Mark II API - User & Group ID
 */

#ifndef EDV_ID_H
#define EDV_ID_H

#include <glib.h>


typedef struct _EDVUID			EDVUID;
#define EDV_UID(p)			((EDVUID *)(p))

typedef struct _EDVGID			EDVGID;
#define EDV_GID(p)			((EDVGID *)(p))


/*
 *	User ID:
 */
struct _EDVUID {

	gchar		*name;			/* User name */
	gchar		*password;		/* Crypted */

	gint		user_id,
			group_id;

	gchar		*verbose_name;		/* Real name */
	/* Member government_name is depreciated and removed */
	gchar		*home_directory;
	gchar		*shell_program;

};

/*
 *	Group ID:
 */
struct _EDVGID {

	gchar		*name;			/* User name */
	gchar		*password;		/* Crypted */

	gint		group_id;

	GList		*group_members_list;	/* List of gchar * group
						 * member names */

};


/* UID */
extern EDVUID *edv_uid_new(void);
extern void edv_uid_delete(EDVUID *uid);

/* GID */
extern EDVGID *edv_gid_new(void);
extern void edv_gid_delete(EDVGID *gid);


#endif	/* EDV_ID_H */
