/*
                 Endeavour Mark II API - Help Displaying
 */

#ifndef EDV_HELP_H
#define EDV_HELP_H

#include "edv_context.h"


/*
 *	Maps the help browser and displays the help file specified by
 *	subject.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The subject tspecifies the subject. If subject is NULL then the
 *	contents will be displayed.
 */
extern void EDVHelpSubject(
	EDVContext *ctx,
	const gchar *subject
);

#define EDVHelpContents(ctx)	EDVHelpSubject(ctx, NULL)
#define EDVHelp(ctx)		EDVHelpSubject(ctx, NULL)


#endif	/* EDV_HELP_H */
