/*
	     Endeavour Mark II API - Devices List File IO
 */

#ifndef EDV_DEVICES_LIST_H
#define EDV_DEVICES_LIST_H

#include <glib.h>
#include "edv_device.h"


/*
 *	Opens the Devices List from the Devices List file.
 *
 *	The devices_list specifies the Devices List, a GList of
 *	EDVDevice * Devices. The Devices opened from the
 *	Devices List file will be appended to the Devices List.
 *
 *	The path specifies the Devices List file.
 *
 *	Returns the Devices List, a GList of EDVDevice *
 *	Devices.
 */
extern GList *edv_devices_list_file_open(
	GList *devices_list,
	const gchar *path
);

/*
 *	Saves the Devices List to the Devices List file.
 *
 *	The devices_list specifies the Devices List, a GList of
 *	EDVDevice * Devices.
 *
 *	The path specifies the Devices List file.
 */
extern void edv_devices_list_file_save(
	GList *devices_list,
	const gchar *path
);


#endif	/* EDV_DEVICES_LIST_H */
