/*
		Endeavour Mark II API - Get Device Statistics
 */

#ifndef EDV_DEVICE_STAT_H
#define EDV_DEVICE_STAT_H

#include <glib.h>
#include "edv_device.h"
#include "edv_context.h"


/*
 *	Gets the device's statistics.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	The path specifies the full path to any object on the device
 *	including the device's mount point itself but not the device's
 *      device path.
 *
 *      Returns a new dynamically allocated EDVDevice with all of its
 *	statistics filled or NULL on error.
 */
extern EDVDevice *edv_device_stat(
        EDVContext *ctx,
        const gchar *path
);


#endif	/* EDV_DEVICE_STAT_H */
