#include <errno.h>
#include <glib.h>
#include "edv_device.h"
#include "edv_device_get.h"
#include "edv_device_stat.h"
#include "edv_context.h"


EDVDevice *edv_device_stat(
	EDVContext *ctx,
	const gchar *path
);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Gets the device's statistics.
 * 
 *	The ctx specifies the Endeavour 2 context.
 *
 *	The path specifies the full path to any object on the device
 *	including the device's mount point itself but not the device's
 *	device path.
 *
 *	Returns a new dynamically allocated EDVDevice with all of its
 *	statistics filled or NULL on error.
 */
EDVDevice *edv_device_stat(
	EDVContext *ctx,
	const gchar *path
)
{
	EDVDevice *d;

	if((ctx == NULL) || STRISEMPTY(path))
	{
		errno = EINVAL;
		return(NULL);
	}

	d = edv_devices_list_match_path(
		ctx,
		path
	);
	if(d == NULL)
		return(NULL);

	/* Update the device's mount states and statistics so that
	 * we can return a copy of the most up to date information
	 */
	edv_device_update_mount_state(d);
	edv_device_update_stats(d);

	return(edv_device_copy(d));
}
