/*
     Endeavour Mark II API - Device Mounting, Unmounting, and Ejecting
 */

#ifndef EDV_DEVICE_MOUNT_H
#define EDV_DEVICE_MOUNT_H

#include <glib.h>
#include "edv_device.h"
#include "edv_context.h"


/*
 *	Gets the last error message.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	Returns a statically allocated string describing the last
 *	error, the returned string must not be modified or deleted.
 */
extern const gchar *edv_device_mount_get_error(EDVContext *ctx);


/*
 *	Mounts the device.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	The d specifies the device.
 *
 *	If notify is set to TRUE then a mount notify event will be
 *	queued if mounting was successful.
 *
 *	Returns 0 on success and non-zero on error.
 */
extern gint edv_device_mount(
	EDVContext *ctx,
	EDVDevice *d,
	const gboolean notify
);

/*
 *	Unmounts the device.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	The d specifies the device.
 *
 *	If notify is set to TRUE then a unmount notify event will be
 *	queued if unmounting was successful.
 *
 *	Returns 0 on success and non-zero on error.
 */
extern gint edv_device_unmount(
	EDVContext *ctx,
	EDVDevice *d,
	const gboolean notify
);

/*
 *	Ejects the media from the device, unmounting the device first
 *	if needed.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	The d specifies the device.
 *
 *	If notify is set to TRUE then a unmount notify event will be
 *	queued if the device needed to be unmounted and unmounting
 *	was successful.
 *
 *	Returns 0 on success and non-zero on error.
 */
extern gint edv_device_eject(
	EDVContext *ctx,
	EDVDevice *d,
	const gboolean notify
);


#endif	/* EDV_DEVICE_MOUNT_H */
