/*
                 Endeavour Mark II API - Date String Parsing
 */

#ifndef EDV_DATE_PARSE_H
#define EDV_DATE_PARSE_H

#include <glib.h>


/*
 *	Parses the date string.
 *
 *	The s specifies the date string which must be in one of the
 *	following formats:
 *
 *	"D/M/Y"
 *	"D-M-Y"
 *	"D,M,Y"
 *	"D.M.Y"
 *	"D M Y"
 *
 *	The month M may be either the month's number (1 to 12) or the
 *	month's name.
 *
 *	The year Y must be a 4-digit year.
 *
 *	The day specifies the return value for day in the range of 1
 *	to 32.
 *
 *	The month specifies the return value for the month in the range
 *	of 1 to 12.
 *
 *	The year specifies the return value for the year.
 */
extern void edv_date_parse_dmy(
        const gchar *s,
        gint *day, gint *month, gint *year
);

/*
 *	Same as edv_date_parse_dmy() except that the date and time
 *	string is parsed in the format of:
 *
 *	"M D, Y"
 */
extern void edv_date_parse_mdy(
        const gchar *s,
        gint *month, gint *day, gint *year
);

/*
 *	Same as edv_date_parse_dmy() except that the date and time
 *	string is parsed in the format of:
 *
 *	"Y/M/D"
 *	"Y-M-D"
 *	"Y,M,D"
 *	"Y.M.D"
 *	"Y M D"
 */
extern void edv_date_parse_ymd(
        const gchar *s,
        gint *year, gint *month, gint *day
);


/*
 *	Parses the date string in any format.
 *
 *	Calls one of EDVDateParseDate*() by determining the date
 *	format of the date string.
 *
 *	The s specifies the date string.
 */
extern void edv_date_parse_any_date(
        const gchar *s,
        gint *year, gint *month, gint *day
);


/*
 *	Parses the time string.
 *
 *	The s specifies the time string which must be in one of the
 *	following formats:
 *
 *	"H:M[:S][AM|PM]"
 *	"H M[ S][AM|PM]"
 *
 *	To optionally indicate 12-hour time a "AM" or "PM" may be
 *	postfixed to the time string.
 */
extern void edv_date_parse_any_time(
        const gchar *s,
        gint *hour, gint *minutes, gint *seconds
);


/*
 *	Parses the date and time string in any format.
 *
 *	The s specifies the date and time string.
 *
 *	Returns the number of seconds since EPOCH.
 */
extern gulong edv_date_parse_epoch(const gchar *s);


#endif	/* EDV_DATE_PARSE_H */
