/*
		  Endeavour Mark II API - Date Formatting
 */

#ifndef EDV_DATE_FORMAT_H
#define EDV_DATE_FORMAT_H


/*
 *	Date Relativity:
 */
typedef enum {
	EDV_DATE_RELATIVITY_ABSOLUTE,		/* Relative to EPOCH */
	EDV_DATE_RELATIVITY_CURRENT		/* Relative to the current time */
} EDVDateRelativity;


/*
 *	Formats a date and time relative to the current time in
 *	accordance with the configuration specified on the context.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The t specifies the time in seconds since EPOCH.
 *
 *	Returns a statically allocated string describing the date and
 *	time or NULL on error.
 */
extern const gchar *edv_date_format_current(
	EDVContext *ctx,
	const gulong t
);

/*
 *	Formats a date and time string relative to the Common Era of
 *	current locale in accordance with the configuration specified
 *	on the context.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The t specifies the time in seconds since EPOCH.
 *
 *	Returns a statically allocated string describing the date and
 *	time or NULL on error.
 */
extern const gchar *edv_date_format_absolute(
	EDVContext *ctx,
	const gulong t
);

/*
 *	Formats a date and time string relative to the Common Era of
 *	current locale by format.
 *
 *      The ctx specifies the Endeavour 2 Context.
 *
 *      The t specifies the time in seconds since EPOCH.
 *
 *	The format specifies the format string containing strftime(2)
 *	tokens. If format is NULL then the format specified by the
 *	configuration on the context will be used.
 *
 *	Returns a statically allocated string describing the date and
 *	time or NULL on error.
 */
extern const gchar *edv_date_format_absolute_string(
	EDVContext *ctx,
	const gulong t,
	const gchar *format
);

/*
 *	Formats a date and time string with relativity and format
 *	specified by the configuration.
 *
 *	The format and relativity of the date & time is specified by
 *	the configuration on the context.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The t specifies the time in seconds since EPOCH.
 *
 *	Returns a statically allocated string describing the date and
 *	time specified by the configuration or NULL on error.
 */
extern const gchar *edv_date_format(
	EDVContext *ctx,
	const gulong t
);


/*
 *	Formats a date and time string describing the time lapsed in
 *	the format of "<n1> <units1> <n2> <units2>".
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The dt specifies the time lapsed in seconds. If dt is 0 then
 *	"less than a second" will be returned.
 *
 *	Returns a statically allocated string describing the date and
 *	time specified by the configuration or NULL on error.
 */
extern const gchar *edv_date_format_duration(
	EDVContext *ctx,
	const gulong dt
);


#endif	/* EDV_DATE_FORMAT_H */
