/*
		Endeavour Mark II API - Converting Objects

	Copy/converts objects of one type to another.

	Also converts to/from property lists.
 */

#ifndef EDV_CONVERT_OBJ_H
#define EDV_CONVERT_OBJ_H

#include <glib.h>
#include "edv_property.h"
#include "edv_vfs_obj.h"
#include "edv_recycled_obj.h"
#include "edv_archive_obj.h"


/*
 *	Converts the properties list to a VFS object.
 *
 *	The properties_list specifies the properties list, a GList of
 *	EDVProperty *properties.
 *
 *	Returns a new VFS object describing the converted values or
 *	NULL on error. Extranous properties in the properties list
 *	will be ignored. The meta data list will not be converted.
 */
extern EDVVFSObject *edv_convert_properties_list_to_vfs_object(GList *properties_list);

/*
 *	Converts the VFS object to a properties list.
 *
 *	The properties_list specifies the properties list, a GList of
 *	EDVProperty *properties.
 *
 *	The obj specifies the VFS object.
 *
 *	Returns the properties_list. Extranous properties in the
 *	properties list will be ignored. The meta data list will not be
 *	converted.
 */
extern GList *edv_convert_vfs_object_to_properties_list(
	GList *properties_list,
	EDVVFSObject *obj
);


/*
 *	Converts the properties list to a recycled object.
 *
 *	The properties_list specifies the properties list, a GList of
 *	EDVProperty *properties.
 *
 *	Returns a new recycled object describing the converted values
 *	or NULL on error. Extranous properties in the properties list
 *	will be ignored. The meta data list will not be converted.
 */
extern EDVRecycledObject *edv_convert_properties_list_to_recycled_object(GList *properties_list);

/*
 *	Converts the recycled object to a properties list.
 *
 *	The properties_list specifies the properties list, a GList of
 *	EDVProperty *properties.
 *
 *	The obj specifies the recycled object.
 *
 *	Returns the properties_list. Extranous properties in the
 *	properties list will be ignored. The meta data list will not be
 *	converted.
 */
extern GList *edv_convert_recycled_object_to_properties_list(
	GList *properties_list,
	EDVRecycledObject *obj
);


/*
 *	Converts the properties list to an archive object.
 *
 *	The properties_list specifies the properties list, a GList of
 *	EDVProperty *properties.
 *
 *	Returns a new archive object describing the converted values
 *	or NULL on error. Extranous properties in the properties list
 *	will be ignored. The meta data list will not be converted.
 */
extern EDVArchiveObject *edv_convert_properties_list_to_archive_object(GList *properties_list);

/*
 *	Converts the archive object to a properties list.
 *
 *	The properties_list specifies the properties list, a GList of
 *	EDVProperty *properties.
 *
 *	The obj specifies the archive object.
 *
 *	Returns the properties_list. Extranous properties in the
 *	properties list will be ignored. The meta data list will not be
 *	converted.
 */
extern GList *edv_convert_archive_object_to_properties_list(
	GList *properties_list,
	EDVArchiveObject *obj
);


/*
 *	Converts the VFS object to a recycled object.
 *
 *	The obj specifies the VFS object.
 *
 *	Returns a new recycled object describing the converted values or
 *	NULL on error. Extranous properties on the VFS object will be
 *	ignored.
 */
extern EDVRecycledObject *edv_convert_vfs_object_to_recycled_object(EDVVFSObject *obj);

/*
 *	Converts the recycled object to a VFS object.
 *
 *	The obj specifies the recycled object.
 *
 *	Returns a new VFS object describing the converted values or
 *	NULL on error. Extranous properties on the recycled object will
 *	be ignored.
 */
extern EDVVFSObject *edv_convert_recycled_object_to_vfs_object(EDVRecycledObject *obj);


#endif	/* EDV_CONVERT_OBJ_H */
