/*
             Endeavour Mark II API - Context Private Members

	Declaration of the EDVContext for the Endeavour Mark II API
	library modules.

	Not intended to be used by public code.

	See also: edv_context.h
 */

#ifndef EDV_CONTEXT_PRIVATE_H
#define EDV_CONTEXT_PRIVATE_H

#include <glib.h>

#include "cfg.h"

#include "edv_device.h"
#include "edv_mime_type.h"


/*
 *	Endeavour 2 Context:
 */
struct _EDVContext {

	/* This process ID */
	gint		pid;

	/* Locations */
	gchar		*cfg_path,
			*recycle_bin_index_path,
			*prog_path,
			*prog_file;

	/* Configuration file time stamp */
	gulong		cfg_last_modified;

	/* Configuration List */
	CfgList		*cfg_list;

	/* A GList of gchar * parameter name strings */
	GList		*cfg_list_parameters;

	/* UIDs List, GList of EDVUID * UIDs */
	GList		*uids_list;

	/* GIDs List, GList of EDVGID * GIDs */
	GList		*gids_list;

	/* Devices List, GList of EDVDevice * Devices */
	GList		*devices_list;

	/* MIME Types List, GList of EDVMIMEType * MIME Types */
	GList		*mime_types_list;

	/* List of queued interprocess commands to be sent, these
	 * will be sent when edv_context_flush() is called */
	gchar		**queued_command;
	gint		total_queued_commands;

	/* Last error message buffer */
	gchar		*last_error_buf;
	const gchar	*last_error_ptr;

	/* Buffer for returning "static" strings in the
	 * edv_date_format.c module */
	gchar		*date_string_buf;
};


#endif	/* EDV_CONTEXT_PRIVATE_H */
