/*
		      Endeavour Mark II - Archive Object

	For objects within archives.
 */

#ifndef EDV_ARCHIVE_OBJ_H
#define EDV_ARCHIVE_OBJ_H

#include <glib.h>
#include "edv_types.h"

typedef struct _EDVArchiveObject	EDVArchiveObject;
#define EDV_ARCHIVE_OBJECT(p)		((EDVArchiveObject *)(p))


/*
 *	Archive Object:
 */
struct _EDVArchiveObject {

	/* Type */
	EDVObjectType	type;

	/* Index */
	gulong		index;

	/* Name & Location */
	gchar		*name,
			*path;		/* Path of object in archive (may
					 * not be a full path) */

	/* Size (in bytes) */
	gulong		size,			/* Original size */
			storage_size;		/* Size object consumes in
						 * archive */

	/* Link (only for EDV_OBJECT_TYPE_LINK) */
	gchar		*link_target;

	/* Permissions */
	EDVPermissionFlags	permissions;

	/* Time Stamps (in seconds since EPOCH) */
	gulong		access_time,
			modify_time,
			change_time;

	/* Ownership */
	gchar		*owner_name,
			*group_name;

	/* Device Type (for types EDV_OBJECT_TYPE_DEVICE_*) */
	gint		device_type;		/* Device major and minor
						 * numbers (used only if
						 * type is one of
						 * EDV_OBJECT_TYPE_DEVICE_*
						 *
						 * Use edv_device_numbers_parse()
						 * to parse this value */

	/* Encryption Name */
	gchar		*encryption_name;	/* If not NULL then specifies
						 * that this object is
						 * encrypted and the name of
						 * the encryption used */

	/* Compression Ratio */
	gfloat		compression_ratio;	/* 0.0 = not compressed
						 * 1.0 = total compression */

	/* Storage Method Name */
	gchar		*storage_method;

	/* CRC Checksum */
	gchar		*crc;

	/* Meta Data List */
	GList           *meta_data_list;	/* GList of EDVProperty *
						 * properties */

};


/*
 *	Creates a new EDVArchiveObject.
 *
 *	Returns a new dynamically allocated EDVArchiveObject with all of its
 *	values zero'ed or NULL on error.
 */
extern EDVArchiveObject *edv_archive_object_new(void);

/*
 *	Creates a new EDVArchiveObject of a specific type.
 *
 *	The type specifies the EDVArchiveObject's type.
 *
 *	Returns a new dynamically allocated EDVArchiveObject with its type
 *	value set or NULL on error.
 */
extern EDVArchiveObject *edv_archive_object_new_type(const EDVObjectType type);

/*
 *	Coppies the EDVArchiveObject.
 *
 *	The obj specifies the EDVArchiveObject to copy.
 *
 *	Returns a new dynamically allocated copy of the EDVArchiveObject or
 *	NULL on error.
 */
extern EDVArchiveObject *edv_archive_object_copy(EDVArchiveObject *obj);

/*
 *	Sets the EDVArchiveObject's values from another EDVArchiveObject.
 *
 *	The obj specifies the EDVArchiveObject to be set.
 *
 *	The obj_values specifies the values to set obj with.
 */
extern void edv_archive_object_set_object(
	EDVArchiveObject *obj,
	EDVArchiveObject *obj_values
);

/*
 *	Deletes and zeros all the values on the EDVArchiveObject.
 *
 *	The obj specifies the EDVArchiveObject who's values are to be cleared.
 */
extern void edv_archive_object_clear(EDVArchiveObject *obj);

/*
 *	Deletes the EDVArchiveObject.
 *
 *	The obj specifies the EDVArchiveObject to delete.
 */
extern void edv_archive_object_delete(EDVArchiveObject *obj);


#endif	/* EDV_ARCHIVE_OBJ_H */
