/*
	Displays Message In A Dialog
 */

#include <errno.h>
#include <glib.h>
#include <endeavour2.h>

#include "../config.h"


static void print_help(const gchar *prog_name);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


static void print_help(const gchar *prog_name)
{
	g_print(
"Usage: %s <message>\n\
       %s <type> <message>\n\
       %s <type> <title> <message>\n",
	    prog_name,
	    prog_name,
	    prog_name
	);
	g_print("\n\
    The <message> specifies the message to be displayed in the message\n\
    dialog.\n\
\n\
    The <type> specifies the type of dialog which can be one of the\n\
    following:\n\
\n\
        info\n\
        warning\n\
        error\n\
\n\
    The <title> specifies the title to be displayed on the message\n\
    dialog's title bar.\n\
\n"
	);
}


int main(int argc, char *argv[])
{
	gint i;
	const gchar *arg;

        /* Initialize the Endeavour2 Context */
	EDVContext *ctx = edv_context_new();
	edv_context_init(ctx, NULL);

#define CLEANUP_RETURN(_v_)	{	\
					\
 /* Shutdown the Endeavour2 context */	\
 edv_context_delete(ctx);		\
					\
 return(_v_);				\
}

	/* Insufficient arguments? */
	if(argc <= 1)
	{
	    print_help(argv[0]);
	    CLEANUP_RETURN(2);
	}

	/* Handle the arguments */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    /* Help */
	    if(!g_strcasecmp(arg, "--help") ||
	       !g_strcasecmp(arg, "-help") ||
	       !g_strcasecmp(arg, "--h") ||
	       !g_strcasecmp(arg, "-h")
	    )
	    {
		print_help(argv[0]);
		CLEANUP_RETURN(0);
	    }
	    /* Version */
	    else if(!g_strcasecmp(arg, "--version") ||
		    !g_strcasecmp(arg, "-version")
	    )
	    {
		g_print(
"Endeavour Mark II Message Version " PROG_VERSION "\n"
PROG_COPYRIGHT
		);
		CLEANUP_RETURN(0);
	    }
	}

	/* Message only? */
	if(argc == 2)
	{
		edv_message(
			ctx,
			argv[1]
		);
	}
	/* Type and message */
	else if(argc == 3)
	{
		const gchar *type = argv[1];
		if(!g_strcasecmp(type, "info"))
			edv_message_info(
				ctx,
				NULL,
				argv[2],
				NULL
			);
		else if(!g_strcasecmp(type, "warning"))
			edv_message_warning(
				ctx,
				NULL,
				argv[2],
				NULL
			);
		else if(!g_strcasecmp(type, "error"))
			edv_message_error(
				ctx,
				NULL,
				argv[2],
				NULL
			);
	}
	/* Type, title, and message */
	else if(argc == 4)
	{
		const gchar *type = argv[1];
		if(!g_strcasecmp(type, "info"))
			edv_message_info(
				ctx,
				argv[2],
				argv[3],
				NULL
			);
		else if(!g_strcasecmp(type, "warning"))
			edv_message_warning(
				ctx,
				argv[2],
				argv[3],
				NULL
			);
		else if(!g_strcasecmp(type, "error"))
			edv_message_error(
				ctx,
				argv[2],
				argv[3],
				NULL
			);
	}
	else
	{
	    print_help(argv[0]);
	    CLEANUP_RETURN(2);
	}


        /* Flush any pending Endeavour2 operations */
	edv_context_sync(ctx);

	CLEANUP_RETURN(0);
#undef CLEANUP_RETURN
}
