/*
	Append History Event

	Example on how to append a new history event.
 */

#include <stdlib.h>
#include <ctype.h>
#include <glib.h>
#include <endeavour2.h>


static void print_usage(const gchar *prog_name)
{
	g_print(
"Usage: %s <type> [status] [source] [target] [comments]\n",
	    prog_name
	);
}

int main(int argc, char *argv[])
{
        /* Initialize the Endeavour2 Context */
	EDVContext *ctx = edv_context_new();
	edv_context_init(ctx, NULL);

	if(argc > 1)
	{
	    const gchar *type_str = argv[1];
	    EDVHistoryType type;
	    const gint status = (argc > 2) ? atoi(argv[2]) : 0;
	    const gchar *source = (argc > 3) ? argv[3] : NULL;
	    const gchar *target = (argc > 4) ? argv[4] : NULL;
	    const gchar *comments = (argc > 5) ? argv[5] : NULL;

	    if(isdigit(*type_str))
		type = (EDVHistoryType)atoi(type_str);
	    else if(!g_strcasecmp(type_str, "sync_disks"))
		type = EDV_HISTORY_SYNC_DISKS;
	    else if(!g_strcasecmp(type_str, "sync_recbin"))
                type = EDV_HISTORY_SYNC_RECBIN;
            else if(!g_strcasecmp(type_str, "disk_object_create"))
                type = EDV_HISTORY_VFS_OBJECT_CREATE;
            else if(!g_strcasecmp(type_str, "disk_object_copy"))
                type = EDV_HISTORY_VFS_OBJECT_COPY;
            else if(!g_strcasecmp(type_str, "disk_object_move"))
                type = EDV_HISTORY_VFS_OBJECT_MOVE;
            else if(!g_strcasecmp(type_str, "disk_object_link"))
                type = EDV_HISTORY_VFS_OBJECT_LINK;
            else if(!g_strcasecmp(type_str, "disk_object_chown"))
                type = EDV_HISTORY_VFS_OBJECT_CHOWN;
            else if(!g_strcasecmp(type_str, "disk_object_chmod"))
                type = EDV_HISTORY_VFS_OBJECT_CHMOD;
            else if(!g_strcasecmp(type_str, "disk_object_set_time"))
                type = EDV_HISTORY_VFS_OBJECT_CHTIME;
            else if(!g_strcasecmp(type_str, "disk_object_download"))
                type = EDV_HISTORY_VFS_OBJECT_DOWNLOAD;
            else if(!g_strcasecmp(type_str, "disk_object_delete"))
                type = EDV_HISTORY_VFS_OBJECT_DELETE;
            else if(!g_strcasecmp(type_str, "recycled_object_recover"))
                type = EDV_HISTORY_RECYCLED_OBJECT_RECOVER;
            else if(!g_strcasecmp(type_str, "recycled_object_purge"))
                type = EDV_HISTORY_RECYCLED_OBJECT_PURGE;
            else if(!g_strcasecmp(type_str, "recycled_object_purge_all"))
                type = EDV_HISTORY_RECYCLED_OBJECT_PURGE_ALL;
            else if(!g_strcasecmp(type_str, "archive_object_add"))
                type = EDV_HISTORY_ARCHIVE_OBJECT_ADD;
            else if(!g_strcasecmp(type_str, "archive_object_extract"))
                type = EDV_HISTORY_ARCHIVE_OBJECT_EXTRACT;
            else if(!g_strcasecmp(type_str, "archive_object_delete"))
                type = EDV_HISTORY_ARCHIVE_OBJECT_DELETE;
	    else
		type = EDV_HISTORY_UNKNOWN;

	    edv_history_append(
		ctx,
		type,
		edv_time(),
		edv_time() + 1l,
		status,
		source, target, comments
	    );
	}
	else
	{
	    print_usage(argv[0]);
	}

        /* Flush any pending Endeavour2 operations */
	edv_context_sync(ctx);

        /* Shutdown the Endeavour2 context */
	edv_context_delete(ctx);

	return(0);
}
