/*
	Endeavour2 API Introduction 

	Runs Endeavour Mark II (abbriviated Endeavour2) and instructs
	it to show the about dialog.

	This example outlines the basic initialization and shutdown of
	the Endeavour2 API context and using the context to send
	instructions to Endeavour2 (in this case, telling it to
	show the about dialog.
 */

#include <glib.h>				/* Needed by endeavour2.h */
#include <endeavour2.h>				/* All applications using the
						 * Endeavour 2 API must
						 * #include this */

int main(int argc, char *argv[])
{
	/* Create a new Endeavour2 context in which subsequent
	 * calls to the Endeavour2 API will need.
	 */
	EDVContext *ctx = edv_context_new();

	/* Load the default configuration, devices list, and MIME types
	 * on to the context so that subsequent calls to the Endeavour
	 * Mark II API can work with and return useful information.
	 *
	 * This should always be called right after edv_context_new().
	 *
	 * Note, that you must have installed Endeavour2 and
	 * runned it at least once in order to create the user local
	 * configuration for the first time.
	 */
	edv_context_init(ctx, NULL);

	/* Run Endeavour2 (as needed) and have it show the
	 * about dialog.
	 */
	edv_window_about_dialog_map(
		ctx,
		NULL				/* Default page */
	);

	/* You should periodically (typically once per loop)
	 * syncronize the context, what this does is flush (send) any
	 * queued commands to the actual running Endeavour2 process
	 * then waits for it to react, so this call should be expected
	 * to block.
	 *
	 * If you only want to flush any queued commands then just
	 * call edv_context_flush() instead.
	 */
	edv_context_sync(ctx);

	/* Delete all the resources on the context, you should call
	 * this whenever you no longer need to use the context anymore.
	 */
	edv_context_delete(ctx);

	return(0);
}
