/*
                         Configuration List File IO
 */

#ifndef CFGFIO_H
#define CFGFIO_H

#include "cfg.h"


/* Open */
extern gint CFGFileOpen(
	const gchar *path,
	CfgList *list
);
extern gint CFGFileOpenProgress(
	const gchar *path,
	CfgList *list,
	gint (*progress_cb)(
		const gulong,
		const gulong,
		gpointer
	),
	gpointer progress_data
);

/* Save */
extern gint CFGFileSave(
	const gchar *path,
	const CfgList *list
);
extern gint CFGFileSaveProgress(
	const gchar *path,
	const CfgList *list,
	gint (*progress_cb)(
		const gulong,
		const gulong,
		gpointer
	),
	gpointer progress_data
);


#endif	/* CFGFIO_H */
