#ifndef IMGIO_FORMAT_H
#define IMGIO_FORMAT_H


/*
 *	Format Extensions:
 */
#define IMAGE_FORMAT_EXTENSION_BMP	".bmp"
#define IMAGE_FORMAT_EXTENSION_DCX	".dcx"
#define IMAGE_FORMAT_EXTENSION_FAXG3	".fax"
#define IMAGE_FORMAT_EXTENSION_GBM	".gbm"
#define IMAGE_FORMAT_EXTENSION_GIF	".gif"
#define IMAGE_FORMAT_EXTENSION_GREY	".grey"
#define IMAGE_FORMAT_EXTENSION_HRZ	".hrz"
#define IMAGE_FORMAT_EXTENSION_JFIF	".jfif"
#define IMAGE_FORMAT_EXTENSION_JPE	".jpe"
#define IMAGE_FORMAT_EXTENSION_JPEG	".jpeg"
#define IMAGE_FORMAT_EXTENSION_JPG	".jpg"
#define IMAGE_FORMAT_EXTENSION_JNG	".jng"
#define IMAGE_FORMAT_EXTENSION_MNG	".mng"
#define IMAGE_FORMAT_EXTENSION_MPC	".mpc"
#define IMAGE_FORMAT_EXTENSION_PAT	".pat"
#define IMAGE_FORMAT_EXTENSION_PBM	".pbm"
#define IMAGE_FORMAT_EXTENSION_PCD	".pcd"
#define IMAGE_FORMAT_EXTENSION_PCX	".pcx"
#define IMAGE_FORMAT_EXTENSION_PIC	".pic"
#define IMAGE_FORMAT_EXTENSION_PICT	".pict"
#define IMAGE_FORMAT_EXTENSION_PIX	".pix"
#define IMAGE_FORMAT_EXTENSION_PGM	".pgm"
#define IMAGE_FORMAT_EXTENSION_PNG	".png"
#define IMAGE_FORMAT_EXTENSION_PNM	".pnm"
#define IMAGE_FORMAT_EXTENSION_PPM	".ppm"
#define IMAGE_FORMAT_EXTENSION_PS	".ps"
#define IMAGE_FORMAT_EXTENSION_PS2	".ps2"
#define IMAGE_FORMAT_EXTENSION_PS3	".ps3"
#define IMAGE_FORMAT_EXTENSION_PSD	".psd"
#define IMAGE_FORMAT_EXTENSION_RGB	".rgb"
#define IMAGE_FORMAT_EXTENSION_RGBA	".rgba"
#define IMAGE_FORMAT_EXTENSION_RLE	".rle"
#define IMAGE_FORMAT_EXTENSION_SGI	".sgi"
#define IMAGE_FORMAT_EXTENSION_TGA	".tga"
#define IMAGE_FORMAT_EXTENSION_TARGA	".targa"
#define IMAGE_FORMAT_EXTENSION_TIF	".tif"
#define IMAGE_FORMAT_EXTENSION_TIFF	".tiff"
#define IMAGE_FORMAT_EXTENSION_XBM	".xbm"
#define IMAGE_FORMAT_EXTENSION_XCF	".xcf"
#define IMAGE_FORMAT_EXTENSION_XPM	".xpm"
#define IMAGE_FORMAT_EXTENSION_XWD	".xwd"
#define IMAGE_FORMAT_EXTENSION_WMF	".wmf"


/*
 *	Extensions List:
 */
#define IMAGE_FORMAT_EXTENSIONS_LIST	{			\
	IMAGE_FORMAT_EXTENSION_BMP,				\
        IMAGE_FORMAT_EXTENSION_DCX,				\
        IMAGE_FORMAT_EXTENSION_FAXG3,				\
        IMAGE_FORMAT_EXTENSION_GBM,				\
        IMAGE_FORMAT_EXTENSION_GIF,				\
        IMAGE_FORMAT_EXTENSION_GREY,				\
        IMAGE_FORMAT_EXTENSION_HRZ,				\
        IMAGE_FORMAT_EXTENSION_JFIF,				\
        IMAGE_FORMAT_EXTENSION_JPE,				\
        IMAGE_FORMAT_EXTENSION_JPEG,				\
        IMAGE_FORMAT_EXTENSION_JPG,				\
        IMAGE_FORMAT_EXTENSION_JNG,				\
        IMAGE_FORMAT_EXTENSION_MNG,				\
        IMAGE_FORMAT_EXTENSION_MPC,				\
        IMAGE_FORMAT_EXTENSION_PAT,				\
        IMAGE_FORMAT_EXTENSION_PBM,				\
        IMAGE_FORMAT_EXTENSION_PCD,				\
        IMAGE_FORMAT_EXTENSION_PCX,				\
        IMAGE_FORMAT_EXTENSION_PIC,				\
        IMAGE_FORMAT_EXTENSION_PICT,				\
        IMAGE_FORMAT_EXTENSION_PIX,				\
        IMAGE_FORMAT_EXTENSION_PGM,				\
        IMAGE_FORMAT_EXTENSION_PNG,				\
        IMAGE_FORMAT_EXTENSION_PNM,				\
        IMAGE_FORMAT_EXTENSION_PPM,				\
        IMAGE_FORMAT_EXTENSION_PS,				\
        IMAGE_FORMAT_EXTENSION_PS2,				\
        IMAGE_FORMAT_EXTENSION_PS3,				\
        IMAGE_FORMAT_EXTENSION_PSD,				\
        IMAGE_FORMAT_EXTENSION_RGB,				\
        IMAGE_FORMAT_EXTENSION_RGBA,				\
        IMAGE_FORMAT_EXTENSION_RLE,				\
        IMAGE_FORMAT_EXTENSION_SGI,				\
        IMAGE_FORMAT_EXTENSION_TGA,				\
        IMAGE_FORMAT_EXTENSION_TARGA,				\
        IMAGE_FORMAT_EXTENSION_TIF,				\
        IMAGE_FORMAT_EXTENSION_TIFF,				\
        IMAGE_FORMAT_EXTENSION_XBM,				\
        IMAGE_FORMAT_EXTENSION_XCF,				\
        IMAGE_FORMAT_EXTENSION_XPM,				\
        IMAGE_FORMAT_EXTENSION_XWD,				\
        IMAGE_FORMAT_EXTENSION_WMF,				\
	NULL							\
}

/*
 *	File Types List:
 *
 *	Suitable for file selector file types lists. Each file type's
 *	extension may have including aliases, example:
 *	".jpg .jfif .jpe .jpeg". Note that the default extension is the
 *	first one.
 */
#define IMAGE_FORMAT_FILE_TYPES_LIST	{			\
	IMAGE_FORMAT_EXTENSION_BMP,	"Windows Bitmap",	\
	IMAGE_FORMAT_EXTENSION_DCX,	"ZSoft Multiple Page PaintBrush Image", \
	IMAGE_FORMAT_EXTENSION_FAXG3,	"FAX Group3",		\
	IMAGE_FORMAT_EXTENSION_GBM,	"GBM Image Format",	\
	IMAGE_FORMAT_EXTENSION_GIF,	"Compuserve Graphics Interchange Format", \
	IMAGE_FORMAT_EXTENSION_GREY,	"Raw Greyscale",	\
	IMAGE_FORMAT_EXTENSION_HRZ,	"HRZ Image Format",	\
	IMAGE_FORMAT_EXTENSION_JPG " "				\
		IMAGE_FORMAT_EXTENSION_JFIF " "			\
		IMAGE_FORMAT_EXTENSION_JPE " "			\
		IMAGE_FORMAT_EXTENSION_JPEG,			\
					"Joint Photographic Experts Group", \
	IMAGE_FORMAT_EXTENSION_JNG,	"JPEG Network Graphics", \
	IMAGE_FORMAT_EXTENSION_MNG,	"Multiple-image Network Graphics", \
	IMAGE_FORMAT_EXTENSION_MPC,	"Image Magick Cache",	\
	IMAGE_FORMAT_EXTENSION_PAT,	"PAT Image Format",	\
	IMAGE_FORMAT_EXTENSION_PBM,	"Portable Bitmap",	\
	IMAGE_FORMAT_EXTENSION_PCD,	"Photo CD",		\
	IMAGE_FORMAT_EXTENSION_PCX, 	"ZSoft PaintBrush",	\
	IMAGE_FORMAT_EXTENSION_PIC " "				\
		IMAGE_FORMAT_EXTENSION_PICT,			\
					"Apple Macintosh QuickDraw", \
	IMAGE_FORMAT_EXTENSION_PIX,	"Alias/Wavefront RLE",	\
	IMAGE_FORMAT_EXTENSION_PGM,	"PGM Image Format",	\
	IMAGE_FORMAT_EXTENSION_PNG,	"Portable Network Graphics", \
	IMAGE_FORMAT_EXTENSION_PNM,	"PNM Image Format",	\
	IMAGE_FORMAT_EXTENSION_PPM,	"PPM Image Format",	\
	IMAGE_FORMAT_EXTENSION_PS,	"Adobe ISO PostScript",	\
	IMAGE_FORMAT_EXTENSION_PS2,	"Adobe ISO PostScript 2", \
	IMAGE_FORMAT_EXTENSION_PS3,	"Adobe ISO PostScript 3", \
	IMAGE_FORMAT_EXTENSION_PSD,	"Adobe Photoshop Bitmap", \
	IMAGE_FORMAT_EXTENSION_RLE,	"Utah Run Length Encoded", \
	IMAGE_FORMAT_EXTENSION_RGB,	"Raw RGB",		\
	IMAGE_FORMAT_EXTENSION_RGBA,	"Raw RGBA",		\
	IMAGE_FORMAT_EXTENSION_SGI,	"Irix",			\
	IMAGE_FORMAT_EXTENSION_TGA " "				\
		IMAGE_FORMAT_EXTENSION_TARGA,			\
					"Targa",		\
	IMAGE_FORMAT_EXTENSION_TIF " "				\
		IMAGE_FORMAT_EXTENSION_TIFF,			\
					"Tagged Image File Format", \
	IMAGE_FORMAT_EXTENSION_XBM,	"X Bitmap",		\
	IMAGE_FORMAT_EXTENSION_XCF,	"GIMP Image Format",	\
	IMAGE_FORMAT_EXTENSION_XPM,	"X Pixmap",		\
	IMAGE_FORMAT_EXTENSION_XWD,	"X Image",		\
	IMAGE_FORMAT_EXTENSION_WMF,	"Windows Meta File",	\
	NULL,				NULL			\
}


#endif	/* IMGIO_FORMAT_H */
