/*
               Endeavour Mark II - Image Browser - Operations
 */

#ifndef IMAGE_BROWSER_OP_H
#define IMAGE_BROWSER_OP_H

#include <gtk/gtk.h>
#include "tool_bar.h"
#include "edv_types.h"
#include "libendeavour2-base/edv_vfs_obj.h"
#include "edv_device.h"
#include "edv_mount_bar.h"
#include "edv_find_bar.h"
#include "edv_status_bar.h"
#include "image_browser.h"


extern void edv_image_browser_op_cb(
	ToolBarItem *item,
	const gint id,
	gpointer data
);
extern void edv_image_browser_op_enter_cb(
	ToolBarItem *item,
	const gint id,
	gpointer data
);
extern void edv_image_browser_op_leave_cb(
	ToolBarItem *item,
	const gint id,
	gpointer data
);

extern void edv_image_browser_op_close(EDVImageBrowser *imbr);

extern void edv_image_browser_op_paste(EDVImageBrowser *imbr);
extern void edv_image_browser_op_paste2(
	EDVImageBrowser *imbr,
	EDVVFSObject *obj
);

extern void edv_image_browser_op_refresh(EDVImageBrowser *imbr);
extern void edv_image_browser_op_refresh_all(EDVImageBrowser *imbr);


#endif	/* IMAGE_BROWSER_OP_H */
