/*
               Endeavour Mark II - Image Browser - Thumbs List
 */

#ifndef image_browser_list_h
#define image_browser_list_h

#include <gtk/gtk.h>
#include "edv_device.h"
#include "image_browser.h"


/* Finding */
extern gint edv_image_browser_list_find_by_index(
	EDVImageBrowser *imbr,
	const gulong device_index, const gulong index
);
extern gint edv_image_browser_list_find_by_path(
	EDVImageBrowser *imbr,
	const gchar *path
);

/* Realize Listing */
extern void edv_image_browser_list_realize_listing(EDVImageBrowser *imbr);

/* Get Listing */
extern void edv_image_browser_list_get_listing(
	EDVImageBrowser *imbr,
	const gchar *path,
	const gboolean update_status_bar
);
extern void edv_image_browser_list_clear(EDVImageBrowser *imbr);

/* Thumb Image Load Iteration */
extern gint edv_image_browser_list_load_iterate(
	EDVImageBrowser *imbr,
	const gboolean update_status_bar,
	const gboolean no_enlarge
);

/* Opening */
extern void edv_image_browser_list_open(
	EDVImageBrowser *imbr,
	const gint thumb_num,
	const guint state			/* Key modifiers */
);
extern void edv_image_browser_list_open_with(
	EDVImageBrowser *imbr,
	const gint thumb_num
);

/* Renaming */
extern void edv_image_browser_list_rename_query(
	EDVImageBrowser *imbr,
	const gint thumb_num
);

/* EDVVFSObject Callbacks */
extern void edv_image_browser_list_vfs_object_added_cb(
	EDVImageBrowser *imbr,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_image_browser_list_vfs_object_modified_cb(
	EDVImageBrowser *imbr,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void edv_image_browser_list_vfs_object_removed_cb(
	EDVImageBrowser *imbr,
	const gchar *path
);

/* EDVDevice Mount Callbacks */
extern void edv_image_browser_list_device_mount_cb(
	EDVImageBrowser *imbr, EDVDevice *dev_ptr,
	const gboolean is_mounted
);


#endif	/* image_browser_list_h */
