/*
               Endeavour Mark II - Image Browser - Callbacks
 */

#ifndef IMAGE_BROWSER_CB_H
#define IMAGE_BROWSER_CB_H

#include <gtk/gtk.h>
#include "edv_device.h"
#include "edv_mime_type.h"
#include "image_browser.h"


/* GTK+ Signal Callbacks */
extern void edv_image_browser_realize_cb(GtkWidget *widget, gpointer data);
extern gint edv_image_browser_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint edv_image_browser_key_event_cb(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint edv_image_browser_button_event_cb(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void edv_image_browser_handle_child_attached_cb(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void edv_image_browser_handle_child_detached_cb(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void edv_image_browser_location_bar_icon_realize_cb(GtkWidget *widget, gpointer data);

extern void edv_image_browser_list_realize_cb(GtkWidget *widget, gpointer data);
extern void edv_image_browser_list_select_cb(
	tlist_struct *tlist, GdkEventButton *button, gint thumb_num,
	gpointer data
);
extern void edv_image_browser_list_unselect_cb(
	tlist_struct *tlist, GdkEventButton *button, gint thumb_num,
	gpointer data
);

extern void edv_image_browser_combo_activate_cb(GtkWidget *widget, gpointer data);

extern gint edv_image_browser_load_thumbs_passive_timeout_cb(gpointer data);

/* GtkMenuItem Callbacks */
extern void edv_image_browser_menu_item_cb(GtkWidget *widget, gpointer data);
extern gint edv_image_browser_menu_item_enter_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_image_browser_menu_item_leave_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern void edv_image_browser_menu_item_command_object_op_cb(GtkWidget *widget, gpointer data);
extern void edv_image_browser_menu_item_command_new_object_cb(GtkWidget *widget, gpointer data);
extern gint edv_image_browser_menu_item_command_enter_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_image_browser_menu_item_command_leave_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* Paths List Get Callback */
extern GList *edv_image_browser_get_selected_paths_cb(gpointer data);

/* Go To Directory Callback */
extern void edv_image_browser_goto_directory_cb(gpointer data, const gchar *path);

/* EDVMountBar Callbacks */
extern void edv_image_browser_mount_bar_mount_cb(
	GtkWidget *widget, const gint dev_num, EDVDevice *dev,
	gpointer data
);
extern void edv_image_browser_mount_bar_eject_cb(
	GtkWidget *widget, const gint dev_num, EDVDevice *dev,
	gpointer data
);
extern void edv_image_browser_mount_bar_goto_cb(
	GtkWidget *widget, const gint dev_num, EDVDevice *dev,
	gpointer data
);

/* EDVFindBar Callbacks */
extern const gchar *edv_image_browser_find_bar_location_cb(
	GtkWidget *bar,
	gpointer data
);
extern void edv_image_browser_find_bar_start_cb(
	GtkWidget *bar,
	gpointer data
);
extern void edv_image_browser_find_bar_end_cb(
	GtkWidget *bar,
	const gint nmatches,
	gpointer data
);
extern void edv_image_browser_find_bar_match_cb(
	GtkWidget *bar,
	const gchar *path,
	GList *properties_list,
	const gint line_index,
	const gchar *excerpt,
	gpointer data
);

/* EDVStatusBar Callbacks */
extern void edv_image_browser_status_message_cb(
	GtkWidget *widget,
	const gchar *message,
	gpointer data
);
extern void edv_image_browser_status_progress_cb(
	GtkWidget *widget,
	const gfloat progress,
	gpointer data
);

/* Master Write Protect Changed Callback */
extern void edv_image_browser_master_write_protect_changed_cb(
	EDVImageBrowser *imbr,
	const gboolean state
);

/* Delete Method Changed Callback */
extern void edv_image_browser_delete_method_changed_cb(
	EDVImageBrowser *imbr,
	const EDVDeleteMethod delete_method
);

/* EDVVFSObject Callbacks */
extern void edv_image_browser_vfs_object_added_cb(
	EDVImageBrowser *imbr,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_image_browser_vfs_object_modified_cb(
	EDVImageBrowser *imbr,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void edv_image_browser_vfs_object_removed_cb(
	EDVImageBrowser *imbr,
	const gchar *path
);

/* EDVDevice Mount/Unmount Callback */
extern void edv_image_browser_device_mount_cb(
	EDVImageBrowser *imbr,
	const gint dev_num, EDVDevice *d,
	const gboolean mounted
);

/* EDVRecycledObject Callbacks */
extern void edv_image_browser_recycled_object_added_cb(
	EDVImageBrowser *imbr,
	const guint index
);
extern void edv_image_browser_recycled_object_modified_cb(
	EDVImageBrowser *imbr,
	const guint index
);
extern void edv_image_browser_recycled_object_removed_cb(
	EDVImageBrowser *imbr,
	const guint index
);

/* Window Created/Deleted Callbacks */
extern void edv_image_browser_window_created_cb(
	EDVImageBrowser *imbr,
	const EDVWindowType win_type,
	gpointer win
);
extern void edv_image_browser_window_deleted_cb(
	EDVImageBrowser *imbr, 
	const EDVWindowType win_type,
	gpointer win
);

/* Reconfigured Callback */
extern void edv_image_browser_reconfigured_cb(EDVImageBrowser *imbr);

/* EDVMIMEType Callbacks */
extern void edv_image_browser_mime_type_added_cb(
	EDVImageBrowser *imbr,
	const gint mt_num, EDVMIMEType *m
);
extern void edv_image_browser_mime_type_modified_cb(
	EDVImageBrowser *imbr,
	const gint mt_num, EDVMIMEType *m
);
extern void edv_image_browser_mime_type_removed_cb(
	EDVImageBrowser *imbr,
	const gint mt_num
);

/* EDVDevice Callbacks */
extern void edv_image_browser_device_added_cb(
	EDVImageBrowser *imbr,
	const gint dev_num, EDVDevice *d
);
extern void edv_image_browser_device_modified_cb(
	EDVImageBrowser *imbr,
	const gint dev_num, EDVDevice *d
);
extern void edv_image_browser_device_removed_cb(
	EDVImageBrowser *imbr,
	const gint dev_num
);


#endif	/* IMAGE_BROWSER_CB_H */
