/*
                     Endeavour Mark II - Image Browser
 */

#ifndef IMAGE_BROWSER_H
#define IMAGE_BROWSER_H

#include <gtk/gtk.h>

#include "cfg.h"
#include "imgview.h"
#include "tool_bar.h"
#include "tlist.h"
#include "guiutils.h"
#include "edv_types.h"
#include "edv_pixmap.h"
#include "edv_mime_type.h"


typedef struct _EDVImageBrowser		EDVImageBrowser;
#define EDV_IMBR(p)			((EDVImageBrowser *)(p))

typedef struct _EDVImageBrowserCommand	EDVImageBrowserCommand;
#define EDV_IMAGE_BROWSER_COMMAND(p)	((EDVImageBrowserCommand *)(p))
#define EDV_IMAGE_BROWSER_COMMAND_DATA_KEY	\
					"EDV/ImageBrowser/Command"

typedef struct _EDVImageBrowserOp	EDVImageBrowserOp;
#define EDV_IMAGE_BROWSER_OP(p)		((EDVImageBrowserOp *)(p))


/*
 *	Flags:
 */
typedef enum {
        EDV_IMAGE_BROWSER_MAPPED	= (1 << 0),
        EDV_IMAGE_BROWSER_REALIZED	= (1 << 1),
        EDV_IMAGE_BROWSER_PROCESSING	= (1 << 2),
        EDV_IMAGE_BROWSER_TOOL_BAR_MAPPED	\
					= (1 << 4),
        EDV_IMAGE_BROWSER_LOCATION_BAR_MAPPED	\
					= (1 << 5),
        EDV_IMAGE_BROWSER_MOUNT_BAR_MAPPED	\
					= (1 << 6),
        EDV_IMAGE_BROWSER_FIND_BAR_MAPPED	\
					= (1 << 7),
        EDV_IMAGE_BROWSER_STATUS_BAR_MAPPED	\
					= (1 << 8)
} EDVImageBrowserFlags;


/*
 *	Operation IDs:
 */
typedef enum {

	EDV_IMAGE_BROWSER_OP_NONE	= 0,
	EDV_IMAGE_BROWSER_OP_SEPARATOR	= 100,

	EDV_IMAGE_BROWSER_OP_CLOSE	= 200,
	EDV_IMAGE_BROWSER_OP_EXIT	= 201,

	EDV_IMAGE_BROWSER_OP_SYNC_DISKS	= 300,
	EDV_IMAGE_BROWSER_OP_HISTORY	= 301,
	EDV_IMAGE_BROWSER_OP_RUN	= 302,
	EDV_IMAGE_BROWSER_OP_RUN_TERMINAL	\
					= 303,
	EDV_IMAGE_BROWSER_OP_WRITE_PROTECT	\
					= 304,
	EDV_IMAGE_BROWSER_OP_DELETE_METHOD_RECYCLE	\
					= 308,
	EDV_IMAGE_BROWSER_OP_DELETE_METHOD_PURGE	\
					= 309,

	EDV_IMAGE_BROWSER_OP_NEW	= 400,
	EDV_IMAGE_BROWSER_OP_NEW_FILE	= 401,
	EDV_IMAGE_BROWSER_OP_NEW_DIRECTORY	\
					= 402,
	EDV_IMAGE_BROWSER_OP_NEW_LINK	= 403,
	EDV_IMAGE_BROWSER_OP_NEW_FIFO	= 404,
	EDV_IMAGE_BROWSER_OP_NEW_DEVICE_BLOCK	\
					= 405,
	EDV_IMAGE_BROWSER_OP_NEW_DEVICE_CHARACTER	\
					= 406,
	EDV_IMAGE_BROWSER_OP_NEW_SOCKET	= 407,

	EDV_IMAGE_BROWSER_OP_OPEN	= 500,
	EDV_IMAGE_BROWSER_OP_OPEN_TO	= 501,
	EDV_IMAGE_BROWSER_OP_OPEN_WITH	= 502,

	EDV_IMAGE_BROWSER_OP_COPY_PATH	= 600,
	EDV_IMAGE_BROWSER_OP_COPY_URL	= 601,
	EDV_IMAGE_BROWSER_OP_PASTE	= 610,

	EDV_IMAGE_BROWSER_OP_MOVE	= 700,
	EDV_IMAGE_BROWSER_OP_COPY	= 701,
	EDV_IMAGE_BROWSER_OP_LINK	= 702,
	EDV_IMAGE_BROWSER_OP_RENAME	= 703,
	EDV_IMAGE_BROWSER_OP_CHMOD	= 704,
	EDV_IMAGE_BROWSER_OP_CHOWN	= 705,
	EDV_IMAGE_BROWSER_OP_CHTIME	= 706,
	EDV_IMAGE_BROWSER_OP_DELETE	= 770,
	EDV_IMAGE_BROWSER_OP_PROPERTIES	= 780,

	EDV_IMAGE_BROWSER_OP_SELECT_ALL	= 800,
	EDV_IMAGE_BROWSER_OP_UNSELECT_ALL	\
					= 801,
	EDV_IMAGE_BROWSER_OP_INVERT_SELECTION	\
					= 802,
	EDV_IMAGE_BROWSER_OP_FIND	= 850,

	EDV_IMAGE_BROWSER_OP_DOWNLOAD	= 900,

	EDV_IMAGE_BROWSER_OP_REFRESH	= 1000,
	EDV_IMAGE_BROWSER_OP_REFRESH_ALL	\
					= 1001,

	EDV_IMAGE_BROWSER_OP_GOTO_PARENT	\
					= 1100,
	EDV_IMAGE_BROWSER_OP_GOTO_HOME	= 1101,

	EDV_IMAGE_BROWSER_OP_STOP	= 1200,
	EDV_IMAGE_BROWSER_OP_CONTINUE	= 1201,

	EDV_IMAGE_BROWSER_OP_PRESENTATION_MODE	\
					= 1220,

	EDV_IMAGE_BROWSER_OP_PREVIOUS_IMAGE	\
					= 1230,
	EDV_IMAGE_BROWSER_OP_NEXT_IMAGE	= 1231,

	EDV_IMAGE_BROWSER_OP_ANIMATION	= 1240,
	EDV_IMAGE_BROWSER_OP_ANIMATION_PLAY	\
					= 1241,
	EDV_IMAGE_BROWSER_OP_ANIMATION_PAUSE	\
					= 1242,
	EDV_IMAGE_BROWSER_OP_ANIMATION_PLAY_PAUSE	\
					= 1243,	/* Play/pause */
	EDV_IMAGE_BROWSER_OP_ANIMATION_PREVIOUS_FRAME	\
					= 1245,
	EDV_IMAGE_BROWSER_OP_ANIMATION_NEXT_FRAME	\
					= 1246,

	EDV_IMAGE_BROWSER_OP_ROTATE_TRANSFORM	\
					= 1250,
	EDV_IMAGE_BROWSER_OP_ROTATE_CW90	\
					= 1251,
	EDV_IMAGE_BROWSER_OP_ROTATE_CCW90	\
					= 1252,
	EDV_IMAGE_BROWSER_OP_ROTATE_CW180	\
					= 1253,
	EDV_IMAGE_BROWSER_OP_MIRROR_HORIZONTAL	\
					= 1260,
	EDV_IMAGE_BROWSER_OP_MIRROR_VERTICAL	\
					= 1261,

	EDV_IMAGE_BROWSER_OP_SHOW_TOOL_BAR	\
					= 1300,
	EDV_IMAGE_BROWSER_OP_SHOW_LOCATION_BAR	\
					= 1301,
	EDV_IMAGE_BROWSER_OP_SHOW_MOUNT_BAR	\
					= 1302,
	EDV_IMAGE_BROWSER_OP_SHOW_FIND_BAR	\
					= 1303,
	EDV_IMAGE_BROWSER_OP_SHOW_STATUS_BAR	\
					= 1304,

	EDV_IMAGE_BROWSER_OP_LIST_FILTER	\
					= 1400,
	EDV_IMAGE_BROWSER_OP_SHOW_HIDDEN_OBJECTS	\
					= 1420,
	EDV_IMAGE_BROWSER_OP_SHOW_NOACCESS_OBJECTS	\
					= 1421,
	EDV_IMAGE_BROWSER_OP_SHOW_NONIMAGE_OBJECTS	\
					= 1422,

	EDV_IMAGE_BROWSER_OP_MOUNT	= 1600,	/* Mount/unmount */
	EDV_IMAGE_BROWSER_OP_EJECT	= 1620,
	EDV_IMAGE_BROWSER_OP_DEVICE_CHECK	\
					= 1650,
	EDV_IMAGE_BROWSER_OP_DEVICE_TOOLS	\
					= 1651,
	EDV_IMAGE_BROWSER_OP_DEVICE_FORMAT	\
					= 1652,

	EDV_IMAGE_BROWSER_OP_MIME_TYPES	= 1700,
	EDV_IMAGE_BROWSER_OP_DEVICES	= 1701,

	EDV_IMAGE_BROWSER_OP_NEW_BROWSER	\
					= 1800,
	EDV_IMAGE_BROWSER_OP_NEW_IMBR	= 1801,
	EDV_IMAGE_BROWSER_OP_NEW_ARCHIVER	\
					= 1802,
	EDV_IMAGE_BROWSER_OP_RECYCLE_BIN	\
					= 1900,

	EDV_IMAGE_BROWSER_OP_OPTIONS	= 2000,
	EDV_IMAGE_BROWSER_OP_CUSTOMIZE	= 2001,

	EDV_IMAGE_BROWSER_OP_HELP_CONTENTS	\
					= 3000,
	EDV_IMAGE_BROWSER_OP_HELP_FILE_BROWSER	\
				 	= 3010,
	EDV_IMAGE_BROWSER_OP_HELP_IMAGE_BROWSER	\
					= 3011,
	EDV_IMAGE_BROWSER_OP_HELP_ARCHIVER	\
					= 3012,
	EDV_IMAGE_BROWSER_OP_HELP_RECYCLE_BIN	\
					= 3030,
	EDV_IMAGE_BROWSER_OP_HELP_KEYS_LIST	\
					= 3050,
	EDV_IMAGE_BROWSER_OP_HELP_MIME_TYPES	\
					= 3051,
	EDV_IMAGE_BROWSER_OP_HELP_DEVICES	\
					= 3052,
	EDV_IMAGE_BROWSER_OP_HELP_COMMON_OPERATIONS	\
					= 3053,
	EDV_IMAGE_BROWSER_OP_HELP_ABOUT	\
					= 3100

} EDVImageBrowserOpID;


/*
 *	Command:
 */
struct _EDVImageBrowserCommand {

	EDVImageBrowser	*image_browser;

	gchar		*label,
			*command,
			*description,
			*ext_data;

	CfgMenuItemFlags	flags;

};


/*
 *	Operation:
 */
struct _EDVImageBrowserOp {

	EDVImageBrowserOpID	id;
	EDVOpIDFlags	flags;
	ToolBarItemType	tb_item_type;
	EDVImageBrowser	*image_browser;

	/* Operation callback */
	void		(*func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* ID */
		gpointer			/* OPID */
	);

	/* Enter and leave notify callbacks */
	void		(*enter_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* ID */
		gpointer			/* OPID */
	);
	void		(*leave_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* ID */
		gpointer			/* OPID */
	);

	gchar		*button_name,		/* Name on a button */
			*menu_name,		/* Name on a menu item */
			*tooltip;		/* Tool tip or description (one line) */

	guint		accel_key,		/* Accelerator key */
			accel_mods;		/* Accelerator key modifiers */ 

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

};


/*
 *	Image Browser:
 */
struct _EDVImageBrowser {

	GtkWidget	*toplevel;
	EDVCore		*core;
	EDVImageBrowserFlags	flags;
	gint		freeze_count,
			busy_count,
			passive_busy_count,
			stop_count;
	guint		loading_tocb;

	GList		*op_ids_list;

	GtkWidget	*main_vbox,
			*menu_bar,

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*mount_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,	/* GtkHBox parent for location bar */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,

			*main_paned;		/* GtkHPaned */

	/* GtkMenus and GtkMenuItems */
	GtkWidget	*file_menu,
			*open_mi,
			*open_to_mi,
			*open_to_menu,
			*open_with_mi,
			*new_object_mi,
			*new_object_menu,
			*new_file_mi,
			*new_directory_mi,
			*new_link_mi,
			*new_fifo_mi,
			*new_device_block_mi,
			*new_device_character_mi,
			*new_socket_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_menu,
			*move_mi,
			*copy_mi,
			*link_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*chtime_mi,
			*delete_mi,
			*copy_path_mi,
			*copy_url_mi,
			*paste_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*view_menu,
			*stop_mi,
			*continue_mi,
			*presentation_mode_mi,
			*animation_mi,
			*animation_menu,
			*animation_play_mi,
			*animation_pause_mi,
			*animation_previous_frame_mi,
			*animation_next_frame_mi,
			*rotate_transform_mi,
			*rotate_transform_menu,
			*rotate_transform_cw90_mi,
			*rotate_transform_ccw90_mi,
			*rotate_transform_cw180_mi,
			*rotate_transform_mirror_horizontal_mi,
			*rotate_transform_mirror_vertical_mi,
			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_mount_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*thumbs_list_filter_mi,
			*show_hidden_objects_micheck,
			*show_noaccess_objects_micheck,
			*show_nonimage_objects_micheck,
			*mime_types_mi,

			*device_menu,
			*mount_mi,
			*eject_mi,
			*device_check_mi,
			*device_tools_mi,
			*device_format_mi,
			*devices_mi,

			*settings_menu,
			*write_protect_mi,
			*delete_method_recycle_micheck,
			*delete_method_purge_micheck,
			*options_mi,
			*customize_mi,

			*windows_menu,
			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_menu,
			*help_contents_mi,
			*help_image_browser_mi,
			*help_keys_list_mi,
			*help_mime_types_mi,
			*help_devices_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Tool Bar */
	GtkWidget	*tool_bar;

	/* Mount Bar */
	GtkWidget	*mount_bar;

	/* Find Bar */
	GtkWidget	*find_bar;

	/* Thumbs List */
	tlist_struct	*tlist;

	/* Image Viewer */
	imgview_struct	*imgview;

	/* Status Bar */
	GtkWidget	*status_bar;

	/* Thumbs List Right-Click GtkMenu */
	GtkWidget	*tlist_menu,
			*tlist_open_mi,
			*tlist_open_to_mi,
			*tlist_open_to_menu,
			*tlist_open_with_mi,
			*tlist_mount_mi,
			*tlist_eject_mi,
			*tlist_mount_misep,
			*tlist_move_mi,
			*tlist_copy_mi,
			*tlist_link_mi,
			*tlist_rename_mi,
			*tlist_chmod_mi,
			*tlist_chown_mi,
			*tlist_chtime_mi,
			*tlist_delete_mi,
			*tlist_copy_path_mi,
			*tlist_copy_url_mi,
			*tlist_paste_mi,
			*tlist_properties_mi;

	/* Thumbs list filter */
	gchar		*thumbs_list_filter;

	/* Icons used in the thumbs list */
	EDVPixmap	*directory_parent_icon,
			*file_image_pending_icon,
			*file_image_bad_icon,
			*multiple_frames_icon;

	/* Last selected thumb (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		tlist_selected_thumb;

	/* Selected device, reflects the device of the disk object of
	 * the selected thumb
	 *
	 * The device number corresponds with a device on the core's
	 * list of devices
	 */
	gint		selected_dev_num;


	/* Last known items in recycle bin, this is used as a quick
	 * access value to check if the recycle bin has contents or
	 * not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_nrecycle_bin_items;

	/* Last known write protect state (can be -1 for unknown) */
	gint		last_write_protect_state;
};

#define EDV_IMAGE_BROWSER_IS_PROCESSING(p)	(((p) != NULL) ? \
 ((p)->flags & EDV_IMAGE_BROWSER_PROCESSING) : FALSE)
#define EDV_IMAGE_BROWSER_IS_FROZEN(p)		(((p) != NULL) ? \
 ((p)->freeze_count > 0) : FALSE)
#define EDV_IMAGE_BROWSER_IS_BUSY(p)		(((p) != NULL) ? \
 ((p)->busy_count > 0) : FALSE)
#define EDV_IMAGE_BROWSER_IS_PASSIVE_BUSY(p)	(((p) != NULL) ? \
 ((p)->passive_busy_count > 0) : FALSE)


/* Utilities */
extern EDVImageBrowserOp *edv_image_browser_op_match_by_id(
	EDVImageBrowser *imbr,
	const EDVImageBrowserOpID id
);

/* Title */
extern void edv_image_browser_set_title(
	EDVImageBrowser *imbr,
	const gchar *path
);

/* Location */
extern const gchar *edv_image_browser_get_location(EDVImageBrowser *imbr);
extern void edv_image_browser_set_location(
	EDVImageBrowser *imbr,
	const gchar *path,
	const gboolean record_history
);
extern void edv_image_browser_update_location_icon(
	EDVImageBrowser *imbr,
	const gchar *path
);

/* Selected Objects & Paths */
extern GList *edv_image_browser_get_selected_objects(
	EDVImageBrowser *imbr,
	const gboolean copy
);
extern GList *edv_image_browser_get_selected_paths(EDVImageBrowser *imbr);

/* Regenerating Menus, Bars, etc */
extern void edv_image_browser_accelkeys_regenerate(EDVImageBrowser *imbr);
extern void edv_image_browser_tool_bar_regenerate(EDVImageBrowser *imbr);
extern void edv_image_browser_file_menu_items_regenerate(EDVImageBrowser *imbr);
extern void edv_image_browser_new_object_menu_items_regenerate(EDVImageBrowser *imbr);
extern void edv_image_browser_open_to_menu_regenerate(
	EDVImageBrowser *imbr,
	EDVMIMEType *m
);
extern void edv_image_browser_list_menu_regenerate(EDVImageBrowser *imbr);

/* Sync Configuration */
extern void edv_image_browser_sync_configuration(EDVImageBrowser *imbr);

/* Load Control */
extern void edv_image_browser_queue_loading_process(EDVImageBrowser *imbr);

/* Select Path */
extern void edv_image_browser_select_path(
	EDVImageBrowser *imbr,
	const gchar *path
);

/* EDVImageBrowserOp */
extern GList *edv_image_browser_ops_list_new(EDVImageBrowser *imbr);
extern void edv_image_browser_ops_list_delete(GList *glist);

/* Accel Keys */
extern CfgAccelkeyList *edv_image_browser_accelkeys_new(void);

/* Reload Icons */
extern void edv_image_browser_reload_icons(EDVImageBrowser *imbr);

/* EDVImageBrowser */
extern EDVImageBrowser *edv_image_browser_new(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern void edv_image_browser_sync_data(EDVImageBrowser *imbr);
extern void edv_image_browser_update_display(EDVImageBrowser *imbr);
extern void edv_image_browser_set_busy(
	EDVImageBrowser *imbr,
	const gboolean busy
);
extern void edv_image_browser_set_passive_busy(
	EDVImageBrowser *imbr,
	const gboolean busy
);
extern gboolean edv_image_browser_is_mapped(EDVImageBrowser *imbr);
extern void edv_image_browser_map(EDVImageBrowser *imbr);
extern void edv_image_browser_unmap(EDVImageBrowser *imbr);
extern void edv_image_browser_delete(EDVImageBrowser *imbr);


#endif	/* IMAGE_BROWSER_H */
