/*
			    Icon Selection Dialog
 */

#ifndef ICON_SEL_DLG_H
#define ICON_SEL_DLG_H

#include <gtk/gtk.h>
#include "tlist.h"


/*
 *	Flags:
 */
typedef enum {
	ICON_SEL_DLG_MAPPED		= (1 << 0),
	ICON_SEL_DLG_REALIZED		= (1 << 1),
	ICON_SEL_DLG_DOUBLE_BUFFER	= (1 << 2),
	ICON_SEL_DLG_SHOW_ICON_PATHS	= (1 << 3),
	ICON_SEL_DLG_SHOW_TEXTTIPS	= (1 << 4),
	ICON_SEL_DLG_ENABLE_DRAG_SCROLL	= (1 << 5),	/* Enable middle-click
							 * list scroll */
	ICON_SEL_DLG_RESPONSE_OK	= (1 << 6)
} icon_sel_dlg_flags;


/*
 *	Default Title:
 */
#define ICON_SEL_DLG_DEF_TITLE		"Select Icon"

/*
 *	Default List Height (in pixels):
 */
#define ICON_SEL_DLG_DEF_LIST_HEIGHT	230


/*
 *	Load Invervals (in milliseconds):
 */
#define ICON_SEL_DLG_DEF_LOAD_INT	100l
#define ICON_SEL_DLG_LOAD_INT_LONG	300l


/* Get/Set Location */
extern const gchar *IconSelDlgCurrentLocation(GtkWidget *w);
extern void IconSelDlgChangeLocation(
	GtkWidget *w,
	const gchar *path
);

/* Thumb Image Loading */
extern gboolean IconSelDlgIsLoading(GtkWidget *w);
extern void IconSelDlgQueueLoading(GtkWidget *w);
extern void IconSelDlgStopLoading(GtkWidget *w);

/* Query */
extern gboolean IconSelDlgIsQuery(GtkWidget *w);
extern GList *IconSelDlgQuery(
	GtkWidget *w,
	const gchar *title,
	const gchar *path,
	const gint req_icon_width, const gint req_icon_height,
	GtkWidget *ref_toplevel
);

/* Icon Selector Dialog */
extern GtkWidget *IconSelDlgNew(
	const icon_sel_dlg_flags flags,
	const GtkOrientation list_orientation,
	const gint list_height,
	const gint thumb_width, const gint thumb_height,
	const gint thumb_border,
	const gchar *default_path,
	const gulong load_int
);
extern void IconSelDlgUpdateWidgets(GtkWidget *w);
extern void IconSelDlgMap(GtkWidget *w);
extern void IconSelDlgUnmap(GtkWidget *w);
extern GtkWidget *IconSelDlgRef(GtkWidget *w);
extern GtkWidget *IconSelDlgUnref(GtkWidget *w);
extern void IconSelDlgDelete(GtkWidget *w);


#endif	/* ICON_SEL_DLG_H */

