/*
				 Icon Picker

	The Icon Picker is a small widget that allows the user to
	select and change icons.

	It displays a single icon but can hold a list of icons, allowing
	the user to "switch" to different icons.

	The user can also "changed" an icon with the use of the Icon
	Selector Dialog.

 */

#ifndef ICON_PICKER_H
#define ICON_PICKER_H

#include <gtk/gtk.h>


typedef struct _IconPickerIcon		IconPickerIcon;
#define ICON_PICKER_ICON(p)		((IconPickerIcon *)(p))


/*
 *	Icon:
 */
struct _IconPickerIcon {

	gchar		*label;			/* Descriptive name for this
						 * icon, not the icon file's
						 * name */

	gchar		*path;			/* Full path to the icon file */

	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	gint		width,			/* Size of the pixmap and mask */
			height;

	gpointer	data;			/* User data */
	GtkDestroyNotify	destroy_cb;

};


/*
 *	Flags:
 */
typedef enum {
	ICON_PICKER_REALIZED		= (1 << 0),
	ICON_PICKER_DOUBLE_BUFFER	= (1 << 1),
	ICON_PICKER_SHOW_ICON_NAME	= (1 << 2),	/* Show the icon's
							 * file name */
	ICON_PICKER_SHOW_ICON_PATH	= (1 << 3),	/* Show the icon's
							 * full file name */
	ICON_PICKER_SHOW_ICON_SHADOW	= (1 << 4),	/* Draw a shadow
							 * under the displayed
							 * icon */
	ICON_PICKER_SHOW_TEXTTIPS	= (1 << 5),
	ICON_PICKER_NO_CHANGE_ICON	= (1 << 6),	/* Changing of icons
							 * not allowed */
	ICON_PICKER_CAN_CLEAR_ICON	= (1 << 7),	/* Allow clearing
							 * of icon and show
							 * clear button */
	ICON_PICKER_ACCEPT_SMALLER_SIZE = (1 << 8),	/* Accept icons of
							 * smaller sizes */
	ICON_PICKER_ACCEPT_LARGER_SIZE	= (1 << 9),	/* Accept icons of
							 * larger sizes */
	ICON_PICKER_WARN_DIFFERENT_SIZE	= (1 << 10),	/* Warn if the size
							 * of the icon does
							 * not match the
							 * requested size */
	ICON_PICKER_ACCEPT_DND_DROP	= (1 << 11),
	ICON_PICKER_PROVIDE_DND_DRAG	= (1 << 12),
	ICON_PICKER_HAS_CHANGES		= (1 << 13),
	ICON_PICKER_BUTTON_PRESSED	= (1 << 14),	/* A button is pressed
							 * on the icon */
	ICON_PICKER_DRAG_OVER		= (1 << 15)	/* A drag is currently
							 * over this icon picker */
} IconPickerFlags;


/*
 *	Icon Positions:
 */
typedef enum {
	ICON_PICKER_ICON_POSITION_CENTER,
	ICON_PICKER_ICON_POSITION_UPPER_LEFT,
	ICON_PICKER_ICON_POSITION_TOP,
	ICON_PICKER_ICON_POSITION_UPPER_RIGHT,
	ICON_PICKER_ICON_POSITION_RIGHT,
	ICON_PICKER_ICON_POSITION_LOWER_RIGHT,
	ICON_PICKER_ICON_POSITION_BOTTOM,
	ICON_PICKER_ICON_POSITION_LOWER_LEFT,
	ICON_PICKER_ICON_POSITION_LEFT
} IconPickerIconPosition;


/* Icon */
extern IconPickerIcon *icon_picker_icon_new(void);
extern IconPickerIcon *icon_picker_icon_copy(IconPickerIcon *icon);
extern void icon_picker_icon_delete(IconPickerIcon *icon);

/* Switch To Icon */
extern void icon_picker_switch_to(
	GtkWidget *w,
	const gint i
);

/* Change/Clear Icon */
extern gint icon_picker_change_icon(
	GtkWidget *w,
	const gchar *path,
        const gboolean verbose,
        const gboolean interactive
);
extern gboolean icon_picker_change_icon_query(GtkWidget *w);
extern gboolean icon_picker_clear_icon(GtkWidget *w);

/* Icon Picker */
extern GtkWidget *icon_picker_new(
	const gchar *title,
	const IconPickerFlags flags,
	const IconPickerIconPosition icon_position,
	const gint req_icon_width, const gint req_icon_height,
	const gint display_width, const gint display_height,
	const gint label_width,
	GtkWidget *icon_sel_dlg
);
extern void icon_picker_set_has_changes(
	GtkWidget *w,
	const gboolean has_changes
);
extern void icon_picker_set_switched_icon_cb(
	GtkWidget *w,
	void (*cb)(
		GtkWidget *,			/* Icon Picker */
		const gint,			/* Icon index */
		IconPickerIcon *,	/* Icon */
		gpointer			/* Data */
	),
	gpointer data
);
extern void icon_picker_set_changed_cb(
	GtkWidget *w,
	void (*cb)(
		GtkWidget *,			/* Icon Picker */
		gpointer			/* Data */
	),
	gpointer data
);
extern void icon_picker_set_icon(
	GtkWidget *w,
	const gint i,
	IconPickerIcon *icon
);
extern void icon_picker_set_icons_list(
	GtkWidget *w,
	GList *icons_list			/* Transfered */
);
extern IconPickerIcon *icon_picker_get_icon(
	GtkWidget *w,
	const gint i
);
extern IconPickerIcon *icon_picker_get_current_icon(GtkWidget *w);
extern GList *icon_picker_get_icons_list(GtkWidget *w);
extern void icon_picker_clear(GtkWidget *w);
extern void icon_picker_queue_draw(GtkWidget *w);


#endif	/* ICON_PICKER_H */
