/*
			    History Window
 */

#ifndef HISTORY_WIN_H
#define HISTORY_WIN_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_pixmap.h"
#include "edv_history.h"


typedef struct _edv_history_win_struct	edv_history_win_struct;
#define EDV_HISTORY_WIN(p)		((edv_history_win_struct *)(p))


/*
 *	Flags:
 */
typedef enum {
	EDV_HISTORY_WIN_SHOW_DETAILS	= (1 << 0)
} edv_history_win_flags;


/*
 *	Cell Styles:
 */
typedef enum {
	EDV_HISTORY_CELL_STYLE_SUCCESS,
	EDV_HISTORY_CELL_STYLE_ERROR,		/* General/system/ambiguous */
	EDV_HISTORY_CELL_STYLE_CANCEL		/* Cancel/no/abort */
} edv_history_win_cell_style;
#define EDV_HISTORY_TOTAL_CELL_STYLES	3


/*
 *	History Window:
 */
struct _edv_history_win_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	EDVCore	*core;

	edv_history_win_flags	flags;

	GtkWidget	*main_vbox,
			*find_entry,
			*history_clist,
			*details_btn,
			*auto_scroll_check,
			*refresh_btn,
			*clear_btn,
			*details_separator,
			*details_parent,	/* GtkVBox */
			*details_client,	/* Parented to display_parent */
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*refresh_mi,
			*save_as_mi,
			*clear_mi;

	/* Pixmap and mask pairs used for operation icons */
	EDVPixmap	*other_operation_icon,

			*recycle_bin_icon,

			*object_create_icon,
			*object_copy_icon,
			*object_move_icon,
			*object_link_icon,
			*object_chown_icon,
			*object_chmod_icon,
			*object_chtime_icon,
			*object_download_icon,
			*object_delete_icon,

			*recobj_recover_icon,
			*recobj_purge_icon,

			*arcobj_add_icon,
			*arcobj_extract_icon,
			*arcobj_delete_icon,
			*archive_fix_icon,

			*object_other_small_icon,
			*object_other_medium_icon,

			*error_small_icon,
			*error_medium_icon;

	/* Styles for directory_ctree and contents_clist cells */
	GtkStyle	*cell_style[EDV_HISTORY_TOTAL_CELL_STYLES];

};


/* Callbacks */
extern void EDVHistoryWinHistoryAddedCB(
	edv_history_win_struct *lw,
	const gint h_num, EDVHistory *h
);
extern void EDVHistoryWinHistoryRemovedCB(
	edv_history_win_struct *lw,
	const gint h_num
);

extern void EDVHistoryWinReconfiguredNotifyCB(
	edv_history_win_struct *lw
);
extern void EDVHistoryWinWriteProtectChangedCB(
	edv_history_win_struct *lw,
	const gboolean state
);
extern void EDVHistoryWinDeleteMethodChangedCB(
	edv_history_win_struct *lw,
	const EDVDeleteMethod delete_method
);

/* Operations */
extern void EDVHistoryWinClear(
	EDVCore *core,
	edv_history_win_struct *lw,
	const gboolean confirm,
	GtkWidget *toplevel
);
extern void EDVHistoryWinSaveAs(edv_history_win_struct *lw);

/* Select */
extern void EDVHistoryWinSelect(
	edv_history_win_struct *lw,
	const gint i
);

/* Update List */
extern void EDVHistoryWinUpdateList(edv_history_win_struct *lw);

/* Update Details */
extern void EDVHistoryWinUpdateDetails(
	edv_history_win_struct *lw,
	EDVHistory *h
);

/* Sync Configuration */
extern void EDVHistoryWinSyncConfiguration(edv_history_win_struct *lw);

/* Styles Regenerate */
extern void EDVHistoryWinListStylesRegenerate(edv_history_win_struct *lw);

/* History Window */
extern edv_history_win_struct *EDVHistoryWinNew(EDVCore *core);
extern void EDVHistoryWinShowDetails(
	edv_history_win_struct *lw,
	const gboolean show
);
extern void EDVHistoryWinUpdateMenus(edv_history_win_struct *lw);
extern void EDVHistoryWinSetBusy(edv_history_win_struct *lw, const gboolean busy);
extern gboolean EDVHistoryWinIsMapped(edv_history_win_struct *lw);
extern void EDVHistoryWinMap(edv_history_win_struct *lw);
extern void EDVHistoryWinUnmap(edv_history_win_struct *lw);
extern void EDVHistoryWinDelete(edv_history_win_struct *lw);


#endif	/* HISTORY_WIN_H */
