/*
			     Font Selection Dialog
 */

#ifndef FSD_H
#define FSD_H

#include <gtk/gtk.h>


/* Font Selection Dialog */
extern gint FSDInit(void);
extern void FSDSetStyle(GtkRcStyle *rc_style);
extern void FSDSetTransientFor(GtkWidget *w);
extern gboolean FSDIsQuery(void);
extern void FSDBreakQuery(void);
extern gboolean FSDGetResponse(
	const gchar *title,
	const gchar *ok_label,
	const gchar *cancel_label,
	const gchar *start_font_name,
	gchar **font_name_rtn
);
extern void FSDMap(void);
extern void FSDUnmap(void);
extern void FSDShutdown(void);

/* Font Prompt */
extern GtkWidget *FSDPromptNew(
	const gchar *label,
	const gint label_width,
	const gint entry_width,
	void (*func_cb)(GtkWidget *, gpointer),
	gpointer data
);
extern GtkWidget *FSDPromptNewSimple(
	const gchar *label,
	const gint label_width,
	const gint entry_width
);
extern GtkWidget *FSDPromptGetEntry(GtkWidget *w);
extern GtkWidget *FSDPromptGetButton(GtkWidget *w);
extern const gchar *FSDPromptGetFontName(GtkWidget *w);
extern void FSDPromptSetFontName(
	GtkWidget *w,
	const gchar *font_name
);


#endif	/* FSD_H */
