#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <unistd.h>

#include "../libendeavour2-base/endeavour2.h"

#include "../guiutils.h"
#include "../animicon.h"
#include "../cdialog.h"

#include "fsck_win.h"
#include "fsck_win_cb.h"

#include "config.h"

#include "../animations/disk_icon_00_48x48.xpm"


void fsck_win_realize_cb(GtkWidget *widget, gpointer data);

gint fsck_win_button_press_event_cb(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);
gint fsck_win_text_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

gint fsck_win_timeout_cb(gpointer data);

gint fsck_win_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

static void FSCKWinDoStart(
	FSCKWin *fm, gint dev_num
);
void fsck_win_start_cb(GtkWidget *widget, gpointer data);
void fsck_win_stop_cb(GtkWidget *widget, gpointer data);
void fsck_win_clear_cb(GtkWidget *widget, gpointer data);
void fsck_win_close_cb(GtkWidget *widget, gpointer data);

void fsck_win_select_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
void fsck_win_unselect_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)

#define FCLOSE(p)	(((p) != NULL) ? (gint)fclose(p) : -1)

#define KILL(p,s)       (((p) > 0) ? kill((p), (s)) : -1)
#define UNLINK(p)       (((p) != NULL) ? unlink(p) : -1)


/*
 *	Toplevel GtkWindow "realized" signal callback.
 */
void fsck_win_realize_cb(GtkWidget *widget, gpointer data)
{
	GdkWindow *window;
	FSCKWin *fm = FSCK_WIN(data);
	if((widget == NULL) || (fm == NULL))
		return;

	window = widget->window;
	if(window != NULL)
	{
		gdk_window_set_decorations(
			window,
			GDK_DECOR_BORDER | GDK_DECOR_TITLE | GDK_DECOR_MENU |
			GDK_DECOR_MINIMIZE
		);
		gdk_window_set_functions(
			window,
			GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
		);
		GUISetWMIcon(
			window,
			(guint8 **)disk_icon_00_48x48_xpm
		);
	}

	if(fm->colormap == NULL)
	{
		GdkColor *c;
		GdkColormap *colormap = gtk_widget_get_colormap(widget);

		fm->colormap = GDK_COLORMAP_REF(colormap);

		c = &fm->error_color;
		c->red	= 1.0f * (guint16)-1;
		c->green	= 0.0f * (guint16)-1;
		c->blue	= 0.0f * (guint16)-1;
		GDK_COLORMAP_ALLOC_COLOR(colormap, c);
	}

	fm->flags |= FSCK_WIN_REALIZED;
}

/*
 *	Devices GtkCList "button_press_event" signal callback.
 */
gint fsck_win_button_press_event_cb(
	GtkWidget *widget, GdkEventButton *button, gpointer data
)
{
	gint status = FALSE;
	gint row, column;
	GtkWidget *w;
	GtkCList *clist;
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return(status);

	clist = GTK_CLIST(fm->devices_clist);
	if(clist->clist_window != ((GdkEventAny *)button)->window)
		return(status);

	if(!gtk_clist_get_selection_info(
		clist, button->x, button->y, &row, &column
	))
	{
		row = -1;
		column = 0;
	}

	switch((gint)button->type)
	{
	  case GDK_2BUTTON_PRESS:
		switch(button->button)
		{
		  case 1:
			/* Start FSCK */
			fsck_win_start_cb(widget, data);
			status = TRUE;
			break;
		}
		break;

	  case GDK_BUTTON_PRESS:
		switch(button->button)
		{
		  case 3:
			gtk_clist_freeze(clist);
			if(!(button->state & GDK_CONTROL_MASK) &&
			   !(button->state & GDK_SHIFT_MASK)
			)
				gtk_clist_unselect_all(clist);
			clist->focus_row = row;
			gtk_clist_select_row(clist, row, column);
			gtk_clist_thaw(clist);

			/* Get right click menu widget and map it */
			w = fm->devices_menu;
			if(w != NULL)
				gtk_menu_popup(
					GTK_MENU(w), NULL, NULL,
					NULL, NULL,
					button->button, button->time
				);
			status = TRUE;
			break;
		}
		break;
	}

	return(status);
}

/*
 *	GtkText event signal callback.
 */
gint fsck_win_text_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	gint status = FALSE;
	gint etype;
	GdkEventConfigure *configure;
	GdkEventButton *button;
	GtkText *text;
	FSCKWin *fm = FSCK_WIN(data);
	if((widget == NULL) || (event == NULL) || (fm == NULL))
		return(status);

	etype = (gint)event->type;
	text = GTK_TEXT(widget);  

	switch(etype)
	{
	  case GDK_CONFIGURE:
		configure = (GdkEventConfigure *)event;
/*
		if(widget->window != NULL)
		{
			GdkWindow *window = widget->window;
			gdk_window_set_cursor(
				window,
				(tv->busy_count > 0) ?
					tv->busy_cur : tv->text_cur
			);
			status = TRUE;
		}
 */
		break;

	  case GDK_BUTTON_PRESS:
		button = (GdkEventButton *)event;
		switch(button->button)
		{
		  case GDK_BUTTON4:
			/* Scroll up */
			if(text->vadj != NULL)
			{
				GtkAdjustment *adj = text->vadj;
				const gfloat inc = MAX(
					(0.25f * adj->page_size),
					adj->step_increment
				);
				gfloat v = adj->value - inc;
				if(v > (adj->upper - adj->page_size))
					v = adj->upper - adj->page_size;
				if(v < adj->lower)
					v = adj->lower;
				gtk_adjustment_set_value(adj, v);
			}
			/* Need to mark the GtkText button as 0 or else it will
			 * keep marking
			 */
			GTK_TEXT(widget)->button = 0;
			gtk_grab_remove(widget);
			gtk_signal_emit_stop_by_name(
				GTK_OBJECT(widget), "button_press_event"
			);
			status = TRUE;
			break;

		  case GDK_BUTTON5:
			/* Scroll down */
			if(text->vadj != NULL)
			{
				GtkAdjustment *adj = text->vadj;
				const gfloat inc = MAX(
					(0.25f * adj->page_size),
					adj->step_increment
				);
				gfloat v = adj->value + inc;
				if(v > (adj->upper - adj->page_size))
					v = adj->upper - adj->page_size;
				if(v < adj->lower)
					v = adj->lower;
				gtk_adjustment_set_value(adj, v);
			}
			/* Need to mark the GtkText button as 0 or else it will
			 * keep marking
			 */
			text->button = 0;
			gtk_grab_remove(widget);
			gtk_signal_emit_stop_by_name(
				GTK_OBJECT(widget), "button_press_event"
			);
			status = TRUE;
			break;
		}
		break;

	  case GDK_BUTTON_RELEASE:
		button = (GdkEventButton *)event;
		switch(button->button)
		{
		  case GDK_BUTTON4:
			/* Need to mark the GtkText button as 0 or else it will
			 * keep marking
			 */
			text->button = 0;
			gtk_grab_remove(widget);
			gtk_signal_emit_stop_by_name(
				GTK_OBJECT(widget), "button_release_event"
			);
			status = TRUE;
			break;
		  case GDK_BUTTON5:
			/* Need to mark the GtkText button as 0 or else it will
			 * keep marking
			 */
			text->button = 0;
			gtk_grab_remove(widget);
			gtk_signal_emit_stop_by_name(
				GTK_OBJECT(widget), "button_release_event"
			);
			status = TRUE;
			break;
		}
		break;
	}

	return(status);
}


/*
 *	FSCKWin FSCK timeout callback.
 */
gint fsck_win_timeout_cb(gpointer data)
{
	FILE *fp;
	gint pid;
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return(FALSE);

/* Resets the stop count, restores progress bar to non-checking state,
 * sets fsck_toid=0, closes the fsck stdout and stderr streams, removes
 * fsck stdout and stderr tempory files, removes the current device from
 * the queued list of devices, and starts another check process for the
 * next queued device (if any)
 */
#define END_PROCESS_CLEANUP	{		\
						\
 fm->stop_count = 0;				\
						\
 fsck_win_set_progress(fm, 0.0f, FALSE);	\
						\
 fm->fsck_toid = 0;				\
						\
 KILL(fm->fsck_pid, SIGTERM);			\
 fm->fsck_pid = 0;				\
						\
 (void)FCLOSE(fm->fsck_cstdout);		\
 fm->fsck_cstdout = NULL;			\
 (void)FCLOSE(fm->fsck_cstderr);		\
 fm->fsck_cstderr = NULL;			\
						\
 AnimIconPause(fm->animation_icon);		\
 AnimIconSeek(fm->animation_icon, 0);		\
						\
 /* Another queued device to check? */		\
 if(fm->queued_device_to_check != NULL) {	\
  /* Remove the last queued device from the	\
   * list */					\
  GList *glist = fm->queued_device_to_check;	\
  GList *glist2 = NULL;				\
  if(glist->next != NULL)			\
   glist2 = g_list_copy(glist->next);		\
  fm->queued_device_to_check = glist2;		\
  g_list_free(glist);				\
						\
  /* Check if there is a current device to	\
   * check */					\
  glist = fm->queued_device_to_check;		\
  if(glist != NULL) {				\
   gint dev_num = (gint)gtk_clist_get_row_data(	\
    (GtkCList *)fm->devices_clist,		\
    (gint)glist->data		/* Row index */	\
   );						\
   FSCKWinDoStart(fm, dev_num);		\
  }						\
  else						\
  {						\
   /* Done checking all devices */		\
   gtk_widget_show_raise(fm->toplevel);		\
   edv_play_sound_completed(fm->ctx);		\
   fsck_win_append_message(			\
    fm, fm->text_font, NULL, NULL,		\
    "Check done.\n", TRUE			\
   );						\
  }						\
 }						\
						\
 fsck_win_update_display(fm);			\
						\
}

	/* Need to stop? */
	if(fm->stop_count > 0)
	{
		/* Remove all queued devices */
		g_list_free(fm->queued_device_to_check);
		fm->queued_device_to_check = NULL;

		/* Print interrupted message */
		fsck_win_append_message(
			fm,
			fm->text_font,
			&fm->error_color, NULL,
			"\n*** Check Interrupted! ***\n",
			TRUE
		);

		END_PROCESS_CLEANUP
		return(FALSE);
	}

	/* Process no longer running? */
	pid = fm->fsck_pid;
	if(!edv_pid_exists(pid))
		fm->fsck_pid = pid = 0;

	/* Read from stdout output file */
	fp = fm->fsck_cstdout;
	if(fp != NULL)
	{
		gchar *s;
		for(s = edv_stream_read_str(fp, FALSE);
		    s != NULL;
		    g_free(s), s = edv_stream_read_str(fp, FALSE)
		)
		{
			fsck_win_append_message(
				fm,
				fm->text_font,
				NULL, NULL,
				s,
				TRUE
			);
		}
		g_free(s);
	}

	/* Read from stderr output file */
	fp = fm->fsck_cstderr;
	if(fp != NULL)
	{
		gchar *s;
		for(s = edv_stream_read_str(fp, FALSE);
		    s != NULL;
		    g_free(s), s = edv_stream_read_str(fp, FALSE)
		)
		{
			fsck_win_append_message(
				fm,
				fm->text_font,
				&fm->error_color, NULL,
				s,
				TRUE
			);
		}
		g_free(s);
	}


	/* Process marked as no longer running? */
	if(pid == 0)
	{
		END_PROCESS_CLEANUP
		return(FALSE);
	}

	/* Update progress bar and disk animation icon */
	fsck_win_set_progress(fm, -1.0f, FALSE);

	return(TRUE);
#undef END_PROCESS_CLEANUP
}


/*
 *	FSCKWin toplevel GtkWindow "delete_event" signal callback.
 */
gint fsck_win_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	fsck_win_close_cb(widget, data);

	return(TRUE);
}


/*
 *	Sets up the fsck manager window to start checking the given
 *	device. The fsck program will be runned and timeout callback
 *	set.
 *
 *	Note that his function still needs work to be truely
 *	iterateable.
 */
static void FSCKWinDoStart(
	FSCKWin *fm, gint dev_num
)
{
	gboolean	bad_blocks,
			verbose;
	gint pid;
	const gchar	*shell_cmd,
			*shell_args,
			*fs_type_name;
	gchar		*shell_prog,
			*cmd,
			*prog,
			*prog_name,
			*startup_message;
	GtkWidget *toplevel;
	EDVDevice *dev;

	if(fm == NULL)
		return;

	toplevel = fm->toplevel;

	/* Get the fsck parameters */

	/* Bad Blocks */
	bad_blocks = GTK_TOGGLE_BUTTON_GET_ACTIVE(
		fm->bad_blocks_check
	);

	/* Verbose */
	verbose = GTK_TOGGLE_BUTTON_GET_ACTIVE(
		fm->verbose_check
	);

	/* Get the device */
	dev = EDV_DEVICE(g_list_nth_data(
		fm->devices_list,
		(guint)dev_num
	));
	if(dev == NULL)
		return;

	/* Get the filesystem's conical name */
	fs_type_name = dev->fs_type_name;


	/* Check if this device is already mounted, in which case we
	 * cannot fsck it
	 */
	if(EDV_DEVICE_IS_MOUNTED(dev))
	{
		gchar *msg = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
"El artefacto \"%s\" se monta actualmente.\n\
\n\
Usted debe unmount el artefacto primero antes de verificar.",
#elif defined(PROG_LANGUAGE_FRENCH)
"\"%s\" composant est actuellement mont.\n\
\n\
Vous devez dmont le composant pour pouvoir faire la vrification.",
#else
"Device \"%s\" is currently mounted.\n\
\n\
You must unmount the device before checking.",
#endif
			dev->device_path
		);
		edv_play_sound_warning(fm->ctx);
		CDialogSetTransientFor(toplevel);
		CDialogGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
			"El Cheque Fall",
			msg,
"El artefacto se debe unmounted antes se puede verificar,\n\
esto deber prevenir los errores debido a lectura/escritura\n\
que pueden occure durante el proceso que verifica. Use la\n\
Endeavour otra aplicacin al unmount el artefacto primero.",
#elif defined(PROG_LANGUAGE_FRENCH)
			"La vrification a choue",
			msg,
"L'appareil doit tre dmont avant de pouvoir tre vrifi, \n\
c'est obligatoire, pour empcher des erreurs de lecture/criture \n\
qui pourraient se drouler pendant le procd de vrification.\n\
Utiliser Endeavour ou une autre commande pour faire le dmontage.",
#else
			"Check Failed",
			msg,
"The device must be unmounted before it can be\n\
checked, this is to prevent errors due to read/writes\n\
that may occure during the checking process.\n\
Use Endeavour or another application to unmount\n\
the device first.",
#endif
			CDIALOG_ICON_WARNING,
			CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
			CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
		g_free(msg);
		return;
	}


	/* Check if there is already an fsck process running, in which
	 * case we will increment the stop count so the next call to
	 * the timeout callback stops it
	 */
	pid = fm->fsck_pid;
	if(pid > 0)
	{
		if(edv_pid_exists(pid))
		{
			fm->stop_count++;
			return;
		}
	}

	/* If there is already an existing fsck process timeout, then
	 * we will increment the stop count so the next call to the
	 * timeout callback stops it
	 */
	if(fm->fsck_toid > 0)
	{
		fm->stop_count++;
		return;
	}

	/* Get the FSCK program name based on the filesystem type */
	prog_name = NULL;
	switch(dev->fs_type_code)
	{
	  case EDV_FS_TYPE_MSDOS:
	  case EDV_FS_TYPE_VFAT:
		prog_name = g_strconcat(FSCK_PROG, ".", "msdos", NULL);
		break;
	  case EDV_FS_TYPE_EXT2_OLD:
	  case EDV_FS_TYPE_EXT2:
		prog_name = g_strconcat(FSCK_PROG, ".", "ext2", NULL);
		break;
	  case EDV_FS_TYPE_MINIX_ORIG:
	  case EDV_FS_TYPE_MINIX:
		prog_name = g_strconcat(FSCK_PROG, ".", "minix", NULL);
		break;
	}
	/* Filesystem type not supported? */
	if(prog_name == NULL)
	{
		gchar *msg = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
"Este programa actualmente no sostiene el\n\
filesystem:\n\
\n\
    %s",
#elif defined(PROG_LANGUAGE_FRENCH)
"Ce programme ne supporte pas actuellement\n\
ce Systme de fichier:\n\
\n\
    %s",
#else
"This program currently does not support\n\
the filesystem:\n\
\n\
    %s",
#endif
			fs_type_name
		);
		edv_play_sound_warning(fm->ctx);
		CDialogSetTransientFor(toplevel);
		CDialogGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
			"Filesystem No Sostuvo",
#elif defined(PROG_LANGUAGE_FRENCH)
			"Systme de fichier non support",
#else
			"Filesystem Not Supported",
#endif
			msg,
			NULL,
			CDIALOG_ICON_WARNING,
			CDIALOG_BTNFLAG_OK,
			CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
		g_free(msg);
		return;
	}
	/* Check if the FSCK program exists */
	prog = edv_which(prog_name);
	if(prog == NULL)
	{
		gchar *msg = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
"Incapaz de encontrar el programa de FSCK:\n\
\n\
    %s\n\
\n\
Verifique por favor ese programa es instalado en una\n\
ubicacion especificada por el ambiente de %s y que es\n\
ejecutable por este programa.",
#elif defined(PROG_LANGUAGE_FRENCH)
"Impossible de trouver le programme FSCK:\n\
\n\
    %s\n\
\n\
Verifier ce programme est install dans\n\
un emplacement specifi par l'environnement de %s et\n\
que c'est excutable par ce programme.",
#else
"Unable to find the FSCK program:\n\
\n\
    %s\n\
\n\
Please verify that the program is installed at a location\n\
specified by the %s environment and that it is\n\
executable by this program.",
#endif
			prog_name,
			ENV_VAR_NAME_PATH
		);
		edv_play_sound_warning(fm->ctx);
		CDialogSetTransientFor(toplevel);
		CDialogGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
			"Incapaz De Encontrar El Programa De FSCK",
#elif defined(PROG_LANGUAGE_FRENCH)
			"Impossible de Trouver le programme FSCK",
#else
			"Unable To Find FSCK Program",
#endif
			msg,
			NULL,
			CDIALOG_ICON_WARNING,
			CDIALOG_BTNFLAG_OK,
			CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
		g_free(msg);
		g_free(prog_name);
		return;
	}

	/* Format the command based on the filesystem type */
	cmd = NULL;
	switch(dev->fs_type_code)
	{
	  case EDV_FS_TYPE_MSDOS:
	  case EDV_FS_TYPE_VFAT:
		cmd = g_strdup_printf(
			"%s -a %s %s %s",
			prog,
			verbose ? "-v" : "",
			bad_blocks ? "-t" : "",
			dev->device_path
		);
		break;
	  case EDV_FS_TYPE_EXT2_OLD:
	  case EDV_FS_TYPE_EXT2:
		cmd = g_strdup_printf(
			"%s -p %s %s -f %s",
			prog,
			verbose ? "-v" : "",
			bad_blocks ? "-c" : "",
			dev->device_path
		);
		break;
	  case EDV_FS_TYPE_MINIX_ORIG:
	  case EDV_FS_TYPE_MINIX:
		cmd = g_strdup_printf(
			"%s -a -v -f %s",
			prog, dev->device_path
		);
		break;
	}
	/* Unable to generate command? */
	if(cmd == NULL)
	{
		gchar *msg = g_strdup_printf(
"Unable to generate command to check filesystem type:\n\
\n\
    %s",
			fs_type_name
		);
		edv_play_sound_error(fm->ctx);
		CDialogSetTransientFor(toplevel);
		CDialogGetResponse(
			"Internal Error",
			msg,
			NULL,
			CDIALOG_ICON_ERROR,
			CDIALOG_BTNFLAG_OK,
			CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
		g_free(msg);
		g_free(prog);
		g_free(prog_name);
		return;
	}

startup_message = g_strdup_printf(
"-------------------------------------------------\n\
Checking device %s...\n",
 dev->device_path
);
fsck_win_append_message(
 fm, fm->text_font, NULL, NULL,
 startup_message,
 TRUE
);
g_free(startup_message);
startup_message = NULL;


	/* Get the shell program and arguments */
	shell_cmd = edv_get_s(fm->ctx, EDV_CFG_PARM_PROG_SHELL);
	shell_args = edv_strarg(
		shell_cmd,
		&shell_prog,
		TRUE,                           /* Parse escapes */
		TRUE                            /* Parse quotes */
	);


	/* Close the streams */
	(void)FCLOSE(fm->fsck_cstdout);
	fm->fsck_cstdout = NULL;
	(void)FCLOSE(fm->fsck_cstderr);
	fm->fsck_cstderr = NULL;


	/* Execute the fsck command */
	fm->fsck_pid = pid = edv_system_shell_streams(
		cmd,
		shell_prog,
		shell_args,
		NULL,
		&fm->fsck_cstdout,
		&fm->fsck_cstderr
	);

	g_free(shell_prog);

	if(pid < 0)
	{
		/* Execute failed */
		gchar *msg = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
"Incapaz de ejecutar la orden:\n\
\n\
    %s",
#elif defined(PROG_LANGUAGE_FRENCH)
"Impossible d'executer la commande:\n\
\n\
    %s",
#else
"Unable to execute the command:\n\
\n\
    %s",
#endif
			cmd
		);
		edv_play_sound_error(fm->ctx);
		CDialogSetTransientFor(toplevel);
		CDialogGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
			"Incapaz De Ejecutar La Prden",
#elif defined(PROG_LANGUAGE_FRENCH)
			"Impossible d'excuter la commande",
#else
			"Unable To Execute Command",
#endif
			msg,
			NULL,
			CDIALOG_ICON_ERROR,
			CDIALOG_BTNFLAG_OK,
			CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
		g_free(msg);

		(void)FCLOSE(fm->fsck_cstdout);
		fm->fsck_cstdout = NULL;
		(void)FCLOSE(fm->fsck_cstderr);
		fm->fsck_cstderr = NULL;

		g_free(cmd);
		g_free(prog);
		g_free(prog_name);

		return;
	}

	/* Start playing the animation icon */
	if(!AnimIconIsPlaying(fm->animation_icon))
		AnimIconPlay(fm->animation_icon);

	/* Schedual the timeout callback to monitor this process */
	if(fm->fsck_toid == 0)
	{
		fm->fsck_toid = gtk_timeout_add(
			50l,				/* Milliseconds */
			fsck_win_timeout_cb, fm
		);
	}

	fsck_win_update_display(fm);

	g_free(cmd);
	g_free(prog);
	g_free(prog_name);
}


/*
 *      Start callback.
 */
void fsck_win_start_cb(GtkWidget *widget, gpointer data)
{
	gint dev_num;
	GList *glist;
	GtkCList *clist;
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return;

	clist = (GtkCList *)fm->devices_clist;
	if(clist == NULL)
		return;

	/* Process already running? */
	if(fm->fsck_pid != 0)
		return;

	/* Update the mount states of each device */
	edv_devices_list_update_mount_states(fm->ctx);

	/* Clear output */
	fsck_win_clear_cb(fm->clear_btn, fm);

	/* Clear old queued devices list to check */
	if(fm->queued_device_to_check != NULL)
	{
		g_list_free(fm->queued_device_to_check);
		fm->queued_device_to_check = NULL;
	}

	/* Copy list of selected rows on the devices clist as a list
	 * of queued devices to check.
	 */
	if(clist->selection != NULL)
		fm->queued_device_to_check = g_list_copy(clist->selection);

	/* Start checking the first queued device */
	glist = fm->queued_device_to_check;
	if(glist != NULL)
	{
		dev_num = (gint)gtk_clist_get_row_data(
			clist,
			(gint)glist->data		/* Row index */
		);
		FSCKWinDoStart(fm, dev_num);
	}
}

/*
 *	Stop callback.
 */
void fsck_win_stop_cb(GtkWidget *widget, gpointer data)
{
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return;

	fm->stop_count++;
}

/*
 *	Clear callback.
 */
void fsck_win_clear_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *w;
	GtkEditable *editable;
	GtkText *text;
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return;

	w = fm->output_text;
	if(w == NULL)
		return;

	editable = (GtkEditable *)w;
	text = (GtkText *)w;

	gtk_editable_delete_text(editable, 0, -1);
}

/*
 *	Close button callback.
 */
void fsck_win_close_cb(GtkWidget *widget, gpointer data)
{
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return;

	fsck_win_unmap(fm);
}


/*
 *	Devices clist "select_row" signal callback.
 */
void fsck_win_select_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
)
{
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return;

	/* Check which clist this event is for */
	if(GTK_WIDGET(clist) == fm->devices_clist)
	{
		/* Check if selected row is fully visible, if not then
		 * adjust scroll position to try and make it visible.
		 */
		if(gtk_clist_row_is_visible(clist, row) !=
			GTK_VISIBILITY_FULL
		)
			gtk_clist_moveto(
				clist,
				row, column,        /* Row, column */
				0.5, 0.0            /* Row, column */
			);

		fsck_win_update_display(fm);
	}
}

/*
 *      Devices clist "unselect_row" signal callback.
 */
void fsck_win_unselect_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
)
{
	FSCKWin *fm = FSCK_WIN(data);
	if(fm == NULL)
		return;

	/* Check which clist this event is for */
	if(GTK_WIDGET(clist) == fm->devices_clist)
	{

		fsck_win_update_display(fm);
	}
}
