/*
                              FSCK Front End Window
 */

#ifndef FSCK_WIN_H
#define FSCK_WIN_H

#include <stdio.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "../libendeavour2-base/endeavour2.h"


typedef struct _FSCKWin			FSCKWin;
#define FSCK_WIN(p)			((FSCKWin *)(p))


/*
 *      Flags:
 */
typedef enum {
        FSCK_WIN_MAPPED				= (1 << 0),
        FSCK_WIN_REALIZED			= (1 << 1)
} FSCKWinFlags;


/*
 *	FSCK Window:
 */
struct _FSCKWin {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	GdkColormap	*colormap;
	gint		busy_count,
			freeze_count;
	FSCKWinFlags	flags;
	EDVContext *ctx;

	GdkCursor	*busy_cur;

	GdkColor	error_color;

	GdkFont		*text_font;

	GtkWidget	*devices_clist,
			*bad_blocks_check,
			*verbose_check,
			*output_text,
			*animation_icon,
			*start_btn,
			*stop_btn,
			*clear_btn,
			*close_btn,
			*progress_bar,

			*devices_menu,
			*devices_start_mi,
			*devices_stop_mi;

	/* Queued list of rows in the Devices GtkCList that need
	 * to be checked, a GList of gint row indicies
	 */
	GList		*queued_device_to_check;

	guint		fsck_toid;
	pid_t		fsck_pid;
	FILE		*fsck_cstdout,
			*fsck_cstderr;

	gint		stop_count;
	gfloat		progress_pos_last;

	/* Devices List, GList of EDVDevice * Devices */
	GList		*devices_list;

};


extern void fsck_win_set_devices(
	FSCKWin *win,
	GList *devices_list
);
extern void fsck_win_append_message(
	FSCKWin *win,
	GdkFont *font,
	GdkColor *color_fg, GdkColor *color_bg,
	const gchar *text,
	const gboolean allow_auto_scroll
);

extern FSCKWin *fsck_win_new(EDVContext *ctx);
extern void fsck_win_update_display(FSCKWin *win);
extern void fsck_win_set_busy(
	FSCKWin *win,
	const gboolean busy
);
extern void fsck_win_set_progress(
	FSCKWin *win,
	const gfloat value,
	const gboolean allow_gtk_iteration
);
extern void fsck_win_map(FSCKWin *win);
extern void fsck_win_unmap(FSCKWin *win);
extern void fsck_win_delete(FSCKWin *win);


#endif	/* FSCK_WIN_H */
