/*
                          Format Front End Window
 */

#ifndef FF_WIN_H
#define FF_WIN_H

#include <stdio.h>
#include <gtk/gtk.h>

#include "../libendeavour2-base/endeavour2.h"


typedef struct _FFWinDeviceParameter	FFWinDeviceParameter;
#define FF_WIN_DEVICE_PARAMETER(p)	((FFWinDeviceParameter *)(p))

typedef struct _FFWin			FFWin;
#define FF_WIN(p)			((FFWin *)(p))


/*
 *	Flags:
 */
typedef enum {
	FF_WIN_MAPPED			= (1 << 0),
	FF_WIN_REALIZED			= (1 << 1)
} FFWinFlags;


/*
 *	Stages:
 */
typedef enum {
	FF_WIN_STAGE_FORMAT,
	FF_WIN_STAGE_MKFS
} FFWinStage;

#define FF_WIN_STAGE_HIGHEST		FF_WIN_STAGE_MKFS


/*
 *	Format Programs:
 */
typedef enum {
	FF_WIN_PROGRAM_NONE,
	FF_WIN_PROGRAM_FDFORMAT,
	FF_WIN_PROGRAM_SUPERFORMAT
} FFWinProgram;


/*
 *	Device Parameter:
 */
struct _FFWinDeviceParameter {

	gchar		*name,
			*parameters;

	gulong		size,			/* In bytes */
			cylindars,
			sectors,
			heads;
};


/*
 *	Format Window:
 */
struct _FFWin {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	GdkColormap	*colormap;
	gint		busy_count,
			freeze_count;
	FFWinFlags	flags;
	EDVContext *ctx;

	GdkCursor	*busy_cur;

	GdkColor	*error_color;

	GdkFont		*text_font;

	GtkWidget	*animation_icon,
			*devices_clist,
			*quick_format_check,
			*program_pulistbox,
			*capacity_pulistbox,
			*filesystem_pulistbox,
			*volume_label_entry,
			*verify_check,
			*verbose_check,
			*results_text,
			*progress_bar,

			*devices_menu,
			*devices_start_mi,
			*devices_stop_mi;

	GtkWidget	*start_btn,
			*stop_btn,
			*clear_btn,
			*close_btn;

	/* Queued list of rows in the Devices GtkCList that need
	 * to be formatted, a GList of gint row indicies
	 */
	GList		*queued_devices_list;

	FFWinStage	format_stage;
	guint		format_toid;
	gint		format_pid;
	FILE		*format_cstdout,
			*format_cstderr;

	gint		stop_count;
	gfloat		last_progress_value;

};


/* FFWinDeviceParameter */
extern FFWinDeviceParameter *ff_win_win_device_parameter_new(void);
extern FFWinDeviceParameter *ff_win_win_device_parameter_copy(FFWinDeviceParameter *p);
extern void ff_win_win_device_parameter_delete(FFWinDeviceParameter *p);

/* Message */
extern void ff_win_append_message(
	FFWin *win,
	GdkFont *font,
	GdkColor *color_fg, GdkColor *color_bg,
	const gchar *msg,
	const gboolean auto_scroll
);
extern void ff_win_clear_messages(FFWin *win);

/* Start */
extern void ff_win_start(FFWin *win);
extern void ff_win_start_stage(
        FFWin *win,
        EDVDevice *dev
);

/* FFWin */
extern FFWin *ff_win_new(EDVContext *ctx);
extern void ff_win_set_devices_list(
	FFWin *win,
	GList *devices_list
);
extern gboolean ff_win_select_device_by_device_path(
	FFWin *win,
	const gchar *device_path
);
extern void ff_win_set_quick_format(
	FFWin *win,
	const gboolean quick_format
);
extern void ff_win_set_program(
	FFWin *win,
	const FFWinProgram program
);
extern void ff_win_set_capacity(
	FFWin *win,
	const gchar *capacity
);
extern void FFWinSelectFilesystem(
	FFWin *win,
	const gchar *filesystem
);
extern void ff_win_set_verify(
	FFWin *win,
	const gboolean verify
);
extern void ff_win_set_volume_label(
	FFWin *win,
	const gchar *label
);
extern void ff_win_set_verbose(
	FFWin *win,
	const gboolean verbose
);
extern void ff_win_update_display(FFWin *win);
extern void ff_win_set_busy(FFWin *win, const gboolean busy);
extern void ff_win_draw_animation_icon(FFWin *win);
extern void ff_win_status_progress(
	FFWin *win,
	const gfloat value,
	const gboolean allow_gtk_iteration
);
extern void ff_win_map(FFWin *win);
extern void ff_win_unmap(FFWin *win);
extern void ff_win_delete(FFWin *win);


#endif	/* FF_WIN_H */
