/*
	   Endeavour Format Front End Compile Time Configuration
 */

#ifndef CONFIG_FORMAT_H
#define CONFIG_FORMAT_H

#include "../config.h"


/*
 *      Program name and version:
 */
#ifdef PROG_NAME
# undef PROG_NAME
#endif
#define PROG_NAME		"Format"

#ifdef PROG_NAME_FULL
# undef PROG_NAME_FULL
#endif
#define PROG_NAME_FULL		"Format"


/*
 *	Standard output help message:
 */
#ifdef PROG_HELP_MESG
# undef PROG_HELP_MESG
#endif

#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_HELP_MESG	"\
El uso: format.front [device] [options] [GUI_options]\n\
\n\
    [device] especifica el artefacto para escoger en inicio.\n\
\n\
    [options] puede ser cualquiera de lo Siguiente:\n\
\n\
	--start                 Format de comienzo de comienzo en inicio.\n\
	-s                      Mismo que --start.\n\
	--help                  Pantalla de ayuda de Impresiones (esto) de ayuda y salidas.\n\
	--version               Versin Imprime informacin de versin y salidas.\n\
\n\
    [GUI_options] puede ser cualquier estndar de las opcin a su GUI,\n\
    consulta su manual de GUI para opciones disponibles.\n\
\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_HELP_MESG  "\
Usage: format.front [device] [options] [GUI_options]\n\
\n\
    [device] spcifie l'appareil pour choisir au dmarrage.\n\
\n\
    [options] parmi les suivantes:\n\
\n\
	--start                 Lance le Formattage  l'ouverture.\n\
	-s                      Mme comme --start.\n\
	--help                  Affiche aide cran et sort.\n\
	--version               Information de version et sort.\n\
\n\
    [GUI_options] peut tre n'importe quelle norme d'options  votre\n\
    GUI, consulter le manuel de votre GUI pour les options disponibles.\n\
\n"
#else
#define PROG_HELP_MESG  "\
Usage: format.front [device] [options] [GUI_options]\n\
\n\
    The [device] specifies the device to select at startup, where\n\
    [device] is the device's device path.\n\
\n\
    The [options] can be any of the following:\n\
\n\
	--start                 Start formatting at startup.\n\
	-s                      Same as --start.\n\
\n\
        --quick-format          Specifies to skip the low-level format\n\
                                and only create the filesystem.\n\
\n\
        --program <program>     Specifies the format program, where\n\
                                <program> can be one of:\n\
                                    fdformat\n\
                                    superformat\n\
        -p                      Same as --program.\n\
\n\
        --capacity <parameters>   Specifies the capacity, where\n\
                                <parameters> specifies the device node\n\
                                paths parameters (such as H1440 or\n\
                                h1200).\n\
\n\
        --filesystem <filesystem>   Specifies the filesystem to\n\
                                create on the media after formatting,\n\
                                where <filesystem> is the name of the\n\
                                filesystem (such as msdos or ext2).\n\
\n\
        --no-verify             Specifies to not verify.\n\
\n\
        --label <label>         Specifies the volume label, where\n\
                                <label> is the volume label (up to 11\n\
                                characters).\n\
\n\
        --no-verbose            Specifies to not be verbose.\n\
\n\
	--help                  Prints this help screen and exits.\n\
	--version               Prints version information and exits.\n\
\n\
    The [GUI_options] can be any options standard to your GUI,\n\
    consult your GUI's manual for available options.\n\
\n"
#endif


/*
 *	Format Program Names:
 *
 *	Do not specify the full path because the exact locations will
 *	be automatically detected by looking through the PATH
 *	environment.
 */
#define PROG_NAME_FDFORMAT		"fdformat"
#define PROG_NAME_SUPERFORMAT		"superformat"


/*
 *	MKFS Program Name:
 *
 *	Do not specify any postfixes since the filesystem type will
 *	be automatically postfixed (such as .msdos for msdos becomes
 *	mkfs.msdos).
 *
 *	Do not specify the full path because the exact location will
 *	be automatically detected by looking through the PATH
 *	environment.
 */
#define PROG_NAME_MKFS			"mkfs"


/*
 *	Device Parameters List:
 *
 *	The format must line up with the structure:
 *
 *	gchar		*name;
 *	gchar		*parameters;
 *	gulong		size_in_bytes;
 *	gulong		cylindars;
 *	gulong		sectors;
 *	gulong		heads;
 *
 *	The parameters specifies a string describing the device node's
 *	parameters that will be postfixed to the device node's path,
 *	for example if the parameter string is "H1440" and the device
 *	node path is "/dev/fd0" then the completed device node path
 *	with parameters becomes "/dev/fd0H1440".
 */
#define DEVICE_PARAMETERS_LIST	{					\
{ "3\" 1.44M High Density",		"H1440",	1440000, 80,	18,	2 }, \
{ "5\" 1.2M High Density",		"h1200",	1200000, 80,	15,	2 }, \
									\
{ "5\" 360K Double Density",		"d360",		360000,	40,	9,	2 }, \
									\
{ "5\" 360K High Density",		"h360",		360000, 40,	9,	2 }, \
{ "5\" 410K High Density",		"h410",		410000,	41,	10,	2 }, \
{ "5\" 420K High Density",		"h420",		420000, 42,	10,	2 }, \
{ "5\" 720K High Density",		"h720",		720000, 80,	9,	2 }, \
{ "5\" 880K High Density",		"h880",		880000, 80,	11,	2 }, \
{ "5\" 1.2M High Density",		"h1200",	1200000, 80,	15,	2 }, \
{ "5\" 1.44M High Density",		"h1440",	1440000, 80,	18,	2 }, \
{ "5\" 1.476M High Density",		"h1476",	1476000, 82,	18,	2 }, \
{ "5\" 1.494M High Density",		"h1494",	1494000, 83,	18,	2 }, \
{ "5\" 1.6M High Density",		"h1600",	1600000, 80,	20,	2 }, \
									\
{ "3\" 360K Double Density",		"D360",		360000,	80,	9,	1 }, \
{ "3\" 720K Double Density",		"D720",		720000,	80,	9,	2 }, \
{ "3\" 800K Double Density",		"D800",		800000,	80,	10,	2 }, \
{ "3\" 1.04M Double Density",		"D1040",	1040000, 80,	13,	2 }, \
{ "3\" 1.12M Double Density",		"D1120",	1120000, 80,	14,	2 }, \
									\
{ "3\" 360K High Density",		"H360",		360000,	40,	9,	2 }, \
{ "3\" 720K High Density",		"H720",		720000,	80,	9,	2 }, \
{ "3\" 820K High Density",		"H820",		820000,	82,	10,	2 }, \
{ "3\" 830K High Density",		"H830",		830000,	83,	10,	2 }, \
{ "3\" 1.44M High Density",		"H1440",	1440000, 80,	18,	2 }, \
{ "3\" 1.6M High Density",		"H1600",	1600000, 80,	20,	2 }, \
{ "3\" 1.78M High Density",		"H1680",	1680000, 80,	21,	2 }, \
{ "3\" 1.722M High Density",		"H1722",	1722000, 82,	21,	2 }, \
{ "3\" 1.743M High Density",		"H1743",	1743000, 83,	21,	2 }, \
{ "3\" 1.760M High Density",		"H1760",	1760000, 80,	22,	2 }, \
{ "3\" 1.840M High Density",		"H1840",	1840000, 80,	23,	2 }, \
{ "3\" 1.92M High Density",		"H1920",	1920000, 80,	24,	2 }, \
									\
{ "3\" 2.88M Extra Density",		"E2880",	2880000, 80,	36,	2 }, \
{ "3\" 2.88M CompaQ Extra Density",	"CompaQ",	2880000, 80,	36,	2 }, \
{ "3\" 3.2M Extra Density",		"E3200",	3200000, 80,	40,	2 }, \
{ "3\" 3.52M Extra Density",		"E3520",	3520000, 80,	44,	2 }, \
{ "3\" 3.84M Extra Density",		"E3840",	3840000, 80,	48,	2 }, \
									\
{ NULL,					NULL,		0,	0,	0,	0 } \
}


#endif	/* CONFIG_FORMAT_H */
