#ifndef FIND_WIN_CB_H
#define FIND_WIN_CB_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "find_win.h"


extern void edv_find_win_realize_cb(GtkWidget *widget, gpointer data);
extern gint edv_find_win_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

extern gint edv_find_win_crossing_event_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_find_win_button_event_cb(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void edv_find_win_drag_data_get_cb(
	GtkWidget *widget, GdkDragContext *dc,
	GtkSelectionData *selection_data, guint info, guint t,
	gpointer data
);
extern void edv_find_win_drag_data_delete_cb(
	GtkWidget *widget, GdkDragContext *dc, gpointer data
);

extern void edv_find_win_combo_activate_cb(GtkWidget *widget, gpointer data);

extern void edv_find_win_browse_location_cb(GtkWidget *widget, gpointer data);

extern void edv_find_win_find_by_changed_cb(
	GtkWidget *widget, const gint i, gpointer data
);

extern gint edv_find_win_find_progress_cb(
	const gchar *path, gfloat progress, gpointer data
);

extern void edv_find_win_find_match_cb(
	const gchar *path,
	GList *properties_list,
	gpointer data
);
extern void edv_find_win_find_match_excerpt_cb(
	const gchar *path,
	GList *properties_list,
	const gint line_index,
	const gchar *excerpt,
	gpointer data
);

extern void edv_find_win_click_column_cb(
	GtkCList *clist, gint column, gpointer data
);
extern void edv_find_win_select_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void edv_find_win_unselect_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void edv_find_win_search_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_stop_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_clear_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_close_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_open_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_open_with_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_goto_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_copy_path_cb(GtkWidget *widget, gpointer data);
extern void edv_find_win_copy_url_cb(GtkWidget *widget, gpointer data);

extern void edv_find_win_reconfigured_cb(EDVFindWin *fw);
extern void edv_find_win_write_protect_changed_cb(
	EDVFindWin *fw,
	const gboolean state
);
extern void edv_find_win_delete_method_changed_cb(
	EDVFindWin *fw,
	const EDVDeleteMethod delete_method
);


#endif	/* FIND_WIN_CB_H */
