/*
                     Endeavour Mark II - Find Window
 */

#ifndef FIND_WIN_H
#define FIND_WIN_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _EDVFindWinObject	EDVFindWinObject;
#define EDV_FIND_WIN_OBJECT(p)		((EDVFindWinObject *)(p))

typedef struct _EDVFindWin		EDVFindWin;
#define EDV_FIND_WIN(p)			((EDVFindWin *)(p))


/*
 *	Flags:
 */
typedef enum {
	EDV_FIND_WIN_MAPPED		= (1 << 0),
	EDV_FIND_WIN_REALIZED	= (1 << 1)
} EDVFindWinFlags;


/*
 *	Find By:
 */
typedef enum {
	EDV_FIND_WIN_FIND_BY_NAME,
	EDV_FIND_WIN_FIND_BY_CONTENT,
	EDV_FIND_WIN_FIND_BY_SIZE_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_SIZE_NOT_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_SIZE_LESS_THAN,
	EDV_FIND_WIN_FIND_BY_SIZE_GREATER_THAN,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_NOT_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_LESS_THAN,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_GREATER_THAN
} EDVFindWinFindBy;


/*
 *	Find Using:
 */
typedef enum {
	EDV_FIND_WIN_FIND_USING_LITERAL,
	EDV_FIND_WIN_FIND_USING_REGEX
} EDVFindWinFindUsing;


/*
 *	Total number of columns on the Results GtkCList:
 */
#define EDV_FIND_WIN_RESULTS_LIST_NCOLUMNS	\
					6


/*
 *	Find Window Object:
 */
struct _EDVFindWinObject {

	EDVLocationType	location_type;
	GList		*properties_list;	/* GList of EDVProperty *
						 * properties */

	gint		line_index;

	gchar		*excerpt;

	EDVFindWin	*find_window;
};


/*
 *	Find Window:
 */
struct _EDVFindWin {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		freeze_count,
			busy_count,
			stop_count;
	EDVCore *core;
	EDVFindWinFlags	flags;

	GtkWidget	*main_vbox,
			*find_by_pulistbox,
			*search_combo,
			*location_combo,
			*find_using_pulistbox,
			*browse_location_btn,
			*find_using_box,
			*case_sensitive_check,
			*recursive_check,
			*search_btn,
			*stop_btn,
			*clear_btn,
			*close_btn,
			*results_clist,
			*open_btn,
			*open_with_btn,
			*goto_btn,
			*copy_path_btn,
			*copy_url_btn;

	/* Status Bar */
	GtkWidget	*status_bar;

	/* Results GtkCList Right-Click GtkMenu */
	GtkWidget	*results_clist_menu,
			*results_clist_open_mi,
			*results_clist_open_with_mi,
			*results_clist_goto_mi,
			*results_clist_copy_path_mi,
			*results_clist_copy_url_mi;

	/* Reference to the window that created this find window
	 *
	 * Only of the indexes can be non-negative
	 */
	gint		browser_num,
			imbr_num,
			recbin_num,
			archiver_num;

	EDVLocationType	location_type;

	/* Last known write protect state, can be -1 to indicate
	 * undefined
	 */
	gint		last_write_protect_state;
};


/* Search Value */
extern const gchar *edv_find_win_current_search(EDVFindWin *fw);
extern void edv_find_win_set_search(
	EDVFindWin *fw,
	const gchar *s,
	const gboolean record_history
);

/* Location Type */
extern EDVLocationType edv_find_win_current_location_type(EDVFindWin *fw);
extern void edv_find_win_set_location_type(
        EDVFindWin *fw,
        const EDVLocationType location_type
);

/* Current Location */
extern const gchar *edv_find_win_current_location(EDVFindWin *fw);
extern void edv_find_win_set_location(
	EDVFindWin *fw,
	const gchar *path,
	const gboolean record_history
);

/* Find By */
extern EDVFindWinFindBy edv_find_win_current_find_by(
	EDVFindWin *fw
);
extern void edv_find_win_set_find_by(
	EDVFindWin *fw,
	const EDVFindWinFindBy find_by
);

/* Find Using */
extern EDVFindWinFindUsing edv_find_win_current_find_using(EDVFindWin *fw);
extern void edv_find_win_set_find_using(
	EDVFindWin *fw,
	const EDVFindWinFindUsing find_using
);

/* Reference Window */
extern void edv_find_win_set_reference_window(
	EDVFindWin *fw,
	const gint browser_num,
	const gint imbr_num,
	const gint recbin_num,
	const gint archive_num
);

/* List */
extern void edv_find_win_list_reset_columns(
	EDVFindWin *fw,
	const EDVFindWinFindBy find_by
);
extern void edv_find_win_list_append(
	EDVFindWin *fw,
	GList *properties_list,
	const gint line_index,
	const gchar *excerpt
);
extern void edv_find_win_list_clear(EDVFindWin *fw);

/* Sync Configuration */
extern void edv_find_win_sync_configuration(EDVFindWin *fw);

/* Find Window Object */
EDVFindWinObject *edv_find_win_object_new(void);
void edv_find_win_object_delete(EDVFindWinObject *obj);

/* Find Window */
extern EDVFindWin *edv_find_win_new(EDVCore *core);
extern void edv_find_win_update_display(EDVFindWin *fw);
extern void edv_find_win_set_busy(EDVFindWin *fw, const gboolean busy);
extern gboolean edv_find_win_is_mapped(EDVFindWin *fw);
extern void edv_find_win_map(EDVFindWin *fw);
extern void edv_find_win_unmap(EDVFindWin *fw);
extern void edv_find_win_delete(EDVFindWin *fw);


#endif	/* FIND_WIN_H */
