/*
                             Endeavour Mark II Core
 */

#ifndef ENDEAVOUR2_H
#define ENDEAVOUR2_H

#include <gtk/gtk.h>

#include "cfg.h"
#include "edv_types.h"
#include "about_dlg.h"
#include "vfs_browser.h"
#include "image_browser.h"
#include "archiver.h"
#include "recycle_bin.h"
#include "recycle_bin_desktop_icon.h"
#include "mime_types_list_win.h"
#include "devices_list_win.h"
#include "history_win.h"
#include "prop_dlg.h"
#include "find_win.h"
#include "obj_op_dlg.h"
#include "run_dlg.h"


/*
 *	Endeavour Core Runlevel:
 */
typedef enum {
	EDV_RUNLEVEL_BASE		= 0,
	EDV_RUNLEVEL_CONSTRUCT		= 1,		/* or deconstruct */
	EDV_RUNLEVEL_IDLE		= 2,
	EDV_RUNLEVEL_BACKGROUND		= 3,
	EDV_RUNLEVEL_PREEMPT		= 4
} EDVRunlevel;


/*
 *	Run Flags:
 */
typedef enum {
	EDV_RUN_SAFE_MODE		= (1 << 0),	/* Run in safe mode,
							 * print stdout and
							 * stderr normally
							 * (instead of in
							 * dialogs), and disable
							 * fancy graphics */

	EDV_RUN_STAY_RUNNING		= (1 << 1),	/* Keep the core running
							 * even when all windows
							 * have been closed,
							 * only SIGINT can tell
							 * the core to stop
							 * running */

	EDV_RUN_GTK_INITIALIZED		= (1 << 8)	/* Marks that GTK and
							 * its resources have
							 * been initialized */

} edv_run_flags;


/*
 *	Endeavour Mark II Core:
 */
struct _EDVCore {

	/* Runlevel */
	EDVRunlevel		runlevel;

	/* Run Flags */
	edv_run_flags		run_flags;

	/* Configuration */
        gchar			*cfg_path;	/* Configuration file */
	CfgList			*cfg_list;

	/* Data Type GdkAtoms */
	GdkAtom			data_type_recycled_object_atom,
				data_type_archive_object_atom;

	/* EDVPixmaps List (GList of EDVPixmaps *) */
	GList			*pixmaps_list;


	/* About Dialog */
	AboutDlg		*about_dlg;

	/* File Browsers */
	EDVVFSBrowser	**browser;
	gint			total_browsers;

	/* Image Browsers */
	EDVImageBrowser		**imbr;
	gint			total_imbrs;

	/* Archivers */
	EDVArchiver		**archiver;
	gint			total_archivers;

	/* Recycle Bin */
	edv_recbin_struct	*recbin;
	/* Recycle Bin Desktop Icon */
	EDVRecycleBinDesktopIcon	*recbin_deskicon;
	/* Last known number of EDVRecycledObjects in the Recycle Bin,
	 * this is used as a convience to check if the Recycle Bin has
	 * contents or not
	 */
	gint			last_nrecycle_bin_items;

	/* MIME Types List Window */
	edv_mime_types_list_win_struct	*mime_types_list_win;

	/* Devices List Window */
	edv_devices_list_win_struct	*devices_list_win;

	/* History List Window */
	edv_history_win_struct	*history_list_win;

	/* Options Window */
	GtkWidget		*options_cfg_win;

	/* Customize Window */
	GtkWidget		*customize_cfg_win;

	/* Property Dialogs */
	EDVPropDlg	**prop_dlg;
	gint			total_prop_dlgs;

	/* Find Window */
	EDVFindWin		*find_win;

	/* Object Operations Dialog */
	edv_obj_op_dlg_struct	*obj_op_dlg;

	/* Run Dialog */
	EDVRunDlg	*run_dlg;


	/* Timeout Callback IDs */
	guint		manage_toid,
			check_mount_states_toid;

	/* Idle Callback IDs */
	guint		emit_reconfigured_idle_id,
			emit_master_write_protect_changed_idle_id,
			emit_delete_method_changed_idle_id;

	/* Pending operation flags, signals that a pending operation
	 * should be performed at the next regularly schedualed call
	 * to edv_manage_timeout_cb()
	 */
	EDVCorePendingFlags	pending_flags;

	/* InterPS signal count, counts the number of times external
	 * applications have notified us about pending InterPS
	 * commands that should be processed at the next regularly
	 * schedualed call to edv_manage_timeout_cb()
	 */
	gint		interps_signal_count;

	/* Operation level, indicates if this program is currently
	 * performing some kind of operation such as copying a file,
	 * recycling a file, extracting an archive object, etc
	 *
	 * Level 0 means that no operation is being performed
	 *
	 * This is used to determine reentery into VFS, Archive,
	 * and Recycle Bin operation functions and to avoid some
	 * routine operations
	 */
	gint		op_level;


	/* Error message buffers & pointers */
	gchar		*last_error_buf;	/* Dynamically allocated
						 * string describing the last
						 * error that occured or NULL
						 * if there was no error or
						 * the error was cleared */
	const gchar	*last_error_ptr;	/* Pointer to the last error
						 * message (may or may not
						 * be last_error_buf) or NULL
						 * if there was no error or the
						 * error was cleared */

        /* This process' ID */
        gint		pid; 

	/* This program object path (taken from command line) */
	gchar		*prog_path;

	/* Home directory */
	gchar		*home_path;

	/* This process' user and group ID */
	gint		user_id;		/* Real user id */
	gint		effective_user_id;	/* Effective user id */
	gint		group_id;		/* Real group id */
	gint		effective_group_id;	/* Effective group id */

	/* User IDs list (list of EDVUID *) */
	GList		*uids_list;
	GtkWidget	*users_pulist;

	/* Group IDs list (list of EDVGID *) */
	GList		*gids_list;
	GtkWidget	*groups_pulist;

	/* Verbose string describing (effective) "<username>" and
	 * "<username>@<hostname>"
	 *
	 * This is used for quick setting of title bars since the user
	 * and location do not change (often) at run time
	 */
	gchar		*effective_user_id_str;		/* user */
	gchar		*effective_user_id_host_str;	/* user@hostname */

	/* Cursors list */
	GList		*cursors_list;

	/* Devices List */
	GList		*devices_list;		/* GList of
						 * EDVDevice *
						 * devices */
	GtkWidget	*devices_pulist;	/* Devices Popup List */

	/* MIME Types list */
	GList		*mime_types_list;	/* GList of
						 * EDVMIMEType *
						 * MIME types */

	/* "Open With" Popup List */
	GtkWidget	*open_with_pulist;


	/* MIME Types index hints
	 *
	 * These are index values of the first and last items of a
	 * particular MIME Type class in the list, these indices are
	 * updated in EDVDoUpdateMIMETypeHintIndices()
	 *
	 * These index values may not be valid, they should be only be
	 * used as reference
	 */
	gint		mimetype_system_index_first,
			mimetype_system_index_last;
	gint		mimetype_format_index_first,
			mimetype_format_index_last;
	gint		mimetype_program_index_first,
			mimetype_program_index_last;
	gint		mimetype_unique_index_first,
			mimetype_unique_index_last;


	/* Basic GUI options */
	GdkGeometryFlags	geometry_flags;
	GdkRectangle	geometry;

	gchar		*font_name;
	GdkFont		*font;

	gchar		*fg_color_name, *bg_color_name,
			*sfg_color_name, *sbg_color_name,
			*cfg_color_name, *cbg_color_name,
			*bg_pixmap_path, *sbg_pixmap_path;
	gchar		*wm_name,
			*wm_class,
			*title;

	/* List Scroll (used in edv_list_cb.c) */
	gboolean	list_scroll_active;
	gint		list_scroll_last_x,
			list_scroll_last_y;


	/* User defined GtkRcStyles (if not NULL) */
	GtkRcStyle	*standard_rcstyle,
			*lists_rcstyle;


#if defined(HAVE_IMLIB)
	/* Image Library Handle */
	gpointer	imlib_handle;
#endif

};
#define EDV_CORE(p)			((EDVCore *)(p))
#define EDV_CORE_KEY			"EDV/Core"


#endif	/* ENDEAVOUR2_H */
