/*
        VFS Object High-Level Copy, Move, Link, Rename, ChMod, ChOwn,
	and ChTime.

	See edv_recycle_obj.h for object deleting.
 */

#ifndef EDV_VFS_OBJ_OP_H
#define EDV_VFS_OBJ_OP_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern const gchar *edv_vfs_object_op_get_error(EDVCore *core);

extern gint edv_vfs_object_op_copy(
	EDVCore *core,
	const gchar *src_path,
	const gchar *tar_path,
	GList **new_paths_list_rtn,
	const gboolean archive,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_vfs_object_op_move(
	EDVCore *core,
	const gchar *src_path,
	const gchar *tar_path,
	GList **new_paths_list_rtn,
	const gboolean archive,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_vfs_object_op_link(
	EDVCore *core,
	const gchar *path,
	const gchar *dest_path,
	GList **new_paths_list_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_vfs_object_op_relink(
	EDVCore *core,
	const gchar *path,
	const gchar *new_dest_value,
	GList **modified_paths_list_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_vfs_object_op_rename(
	EDVCore *core,
	const gchar *path,
	const gchar *new_name,
	GList **modified_paths_list_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_vfs_object_op_chmod(
	EDVCore *core,
	GList *paths_list,
	const EDVPermissionFlags permissions,
	GList **modified_paths_list_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean recursive,
	const gboolean archive
);
extern gint edv_vfs_object_op_chown(
	EDVCore *core,
	GList *paths_list,
	const gint owner_id, const gint group_id,
	GList **modified_paths_list_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean recursive,
	const gboolean archive
);
extern gint edv_vfs_object_op_chtime(
	EDVCore *core,
	GList *paths_list,
	const gulong atime, const gulong mtime,
	GList **modified_paths_list_rtn,
	GtkWidget *toplevel,
        const gboolean show_progress,
	const gboolean interactive,
        gboolean *yes_to_all,
	const gboolean recursive,
	const gboolean archive
);


#endif	/* EDV_VFS_OBJ_OP_H */
