/*
                         VFS Object Creating

	See edv_vfs_obj_op.h for the other high-level VFS object
	operations such as copy, move, link, rename, chmod, chown,
	and chtime.
 */

#ifndef EDV_VFS_OBJ_CREATE_H
#define EDV_VFS_OBJ_CREATE_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern const gchar *EDVVFSObjectCreateGetError(EDVCore *core);

extern gint EDVVFSObjectCreateFileQueryName(
        EDVCore *core,
        const gchar *parent_path,
	const gchar *suggested_name,
        gchar **new_path_rtn,
        GtkWidget *toplevel,
        const gboolean show_progress,
        gboolean *yes_to_all
);

extern gint EDVVFSObjectCreateFile(
	EDVCore *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVVFSObjectCreateDirectory(
	EDVCore *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVVFSObjectCreateLink(
	EDVCore *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVVFSObjectCreateFifo(
	EDVCore *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVVFSObjectCreateDeviceBlock(
	EDVCore *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVVFSObjectCreateDeviceCharacter(
	EDVCore *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVVFSObjectCreateSocket(
	EDVCore *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);


#endif	/* EDV_VFS_OBJ_CREATE_H */
