/*
	       Endeavour Mark II - GTK Dependent Utilities
 */

#ifndef EDV_UTILS_GTK_H
#define EDV_UTILS_GTK_H

#include <gtk/gtk.h>

#include "cfg.h"
#include "edv_types.h"
#include "libendeavour2-base/edv_vfs_obj.h"
#include "edv_pixmap.h"
#include "edv_cursor.h"
#include "edv_device.h"
#include "edv_mime_type.h"


/* Accelerator Key Matching */
extern gint edv_match_accel_key_op_id(
	CfgList *cfg_list,
	const gchar *parm,
	const guint accel_key, const guint accel_mods
);
extern CfgAccelkey *edv_match_accel_key(
	CfgList *cfg_list,
	const gchar *parm,
	const gint op_id
);

/* EDVPixmaps */
extern EDVPixmap *edv_load_pixmap_from_data(
	EDVCore *core,
	edv_pixmap_data *data,
	const gchar *name
);
extern EDVPixmap *edv_open_pixmap_from_file(
	EDVCore *core,
	const gchar *path
);
extern EDVPixmap *edv_new_progress_pixmap(
	GdkWindow *window,
	GtkStyle *style,
	const gint width, const gint height,
	const gfloat coeff,
	const gboolean draw_value,
	const GtkOrientation orientation,
	const gboolean reverse
);
extern GtkWidget *edv_new_pixmap_widget(
	EDVCore *core,
	edv_pixmap_data *data,
	const gchar *name
);
extern gchar *edv_get_recycle_bin_icon_path(
	EDVCore *core,
	const EDVIconSize size,
	const gint nrecycled_objects
);
extern edv_pixmap_data *edv_get_recycle_bin_icon_data(
	const EDVIconSize size,
	const gint nrecycled_objects,
	const gchar **c_declaration_id_rtn
);

/* Cursors */
extern GdkCursor *edv_get_cursor(
	EDVCore *core,
	const EDVCursorCode code
);

/* GtkCTree Nodes */
extern gint edv_node_get_level(GtkCTreeNode *node);
extern GtkCTreeNode *edv_node_get_parent(GtkCTreeNode *node);
extern GtkCTreeNode *edv_node_get_child(GtkCTreeNode *node);
extern GtkCTreeNode *edv_node_get_sibling(GtkCTreeNode *node);
extern GtkCTreeNode *edv_ctree_node_get_toplevel(GtkCTree *ctree);

/* GtkCList & GtkCTree Utilities */
extern gint edv_clist_get_selected_last(
	GtkCList *clist,
	GtkCListRow **row_ptr_rtn
);
extern GtkCTreeNode *edv_ctree_get_selected_last(
	GtkCTree *ctree,
	GtkCTreeRow **row_ptr_rtn
);
extern gboolean edv_ctree_node_get_index(
	GtkCTree *ctree,
	GtkCTreeNode *node,
	gint *row_rtn, gint *column_rtn
);
extern GtkCTreeNode *edv_ctree_node_get_by_coordinates(
	GtkCTree *ctree,
	const gint x, const gint y
);
extern void edv_clist_scroll_to_position(
	GtkCList *clist,
	const gfloat hpos, const gfloat vpos
);

/* Endeavour Window Matching */
extern gboolean edv_match_window_from_toplevel(
	EDVCore *core, GtkWidget *toplevel,
	gint *browser_num,
	gint *imbr_num,
	gint *archiver_num,
	gint *recbin_num
);

/* Object Checking */
extern gboolean edv_is_object_name_valid(const gchar *name);
extern gboolean edv_is_object_hidden(EDVVFSObject *obj);

/* Permission Checking */
extern gboolean edv_is_object_accessable(
	EDVCore *core,
	EDVVFSObject *obj
);
extern gboolean edv_is_object_readable(
	EDVCore *core,
	EDVVFSObject *obj
);
extern gboolean edv_is_object_writable(
	EDVCore *core,
	EDVVFSObject *obj
);
extern gboolean edv_is_object_executable(
	EDVCore *core,
	EDVVFSObject *obj
);

/* Internal Supported Object Type Checking */
extern gboolean edv_check_archive_format_supported(
	EDVCore *core,
	const gchar *name
);

/* Message Output */
extern void edv_message(
	const gchar *title,
	const gchar *message,
	const gchar *details,
	GtkWidget *toplevel
);
extern void edv_message_info(
	const gchar *title,
	const gchar *message,
	const gchar *details,
	GtkWidget *toplevel
);
extern void edv_message_warning(
	const gchar *title,
	const gchar *message,
	const gchar *details,
	GtkWidget *toplevel
);
extern void edv_message_error(
	const gchar *title,
	const gchar *message,
	const gchar *details,
	GtkWidget *toplevel
);
extern void edv_message_object_op_error(
	const gchar *title,
	const gchar *message,
	const gchar *path,
	GtkWidget *toplevel
);
extern void edv_message_from_file(
	const gchar *path,
	const gchar *title,
	gint cdialog_icon,
	GtkWidget *toplevel
);

/* Play Sound */
extern void edv_beep(EDVCore *core);
extern void edv_play_sound_beep(EDVCore *core);
extern void edv_play_sound_info(EDVCore *core);
extern void edv_play_sound_question(EDVCore *core);
extern void edv_play_sound_warning(EDVCore *core);
extern void edv_play_sound_error(EDVCore *core);
extern void edv_play_sound_completed(EDVCore *core);

/* Menu & Button Interaction */
extern void edv_map_menu_to_button(GtkWidget *menu, GtkWidget *button);

/* Window Centering */
extern void edv_center_window_to_window(
	GtkWidget *w1,
	GtkWidget *w2
);
extern void edv_center_window_to_window_offset(
	GtkWidget *w1,
	GtkWidget *w2,
	const gint x_offset, const gint y_offset
);

/* GtkEditable & GtkEntry Endowments */
extern void edv_entry_set_dnd(EDVCore *core, GtkWidget *w);
extern void edv_entry_set_complete_path(EDVCore *core, GtkWidget *w);

/* Scrolled Window Setup Utilities */
extern GtkWidget *edv_new_scrolled_window(
	GtkPolicyType hscrollbar_policy,
	GtkPolicyType vscrollbar_policy,
	GtkWidget **event_box_rtn,
	GtkWidget **vbox_rtn
);

/* Copy Object Path Utilities */
extern void edv_copy_paths_to_clipboard(
	EDVCore *core,
	GList *objs_list,
	GtkWidget *owner
);
extern void edv_copy_urls_to_clipboard(
	EDVCore *core,
	GList *objs_list,
	GtkWidget *owner
);

/* Style Utilities */
extern GtkRcStyle *edv_new_rc_style_from_cfg(
	const CfgStyle *style
);

/* History Utilities */
extern void edv_append_history(
	EDVCore *core,
	const EDVHistoryType type,
	const gulong start_time,			/* In seconds since EPOCH */
	const gulong end_time,			/* In seconds since EPOCH */
	const gint status,
	const gchar *source,			/* Source path, name, or value */
	const gchar *target,			/* Target path, name, or value */
	const gchar *comments
);

/* Write Protect Utilities */
extern gboolean edv_check_master_write_protect(
	EDVCore *core,
	const gboolean verbose,
	GtkWidget *toplevel
);

/* Query Name Filter */
extern gboolean edv_query_name_filter(
	EDVCore *core,
	gchar **filter_rtn,
	GtkWidget *toplevel
);


#endif	/* EDV_UTILS_GTK_H */
