/*
	   Recycled Object Renaming, ChMod, ChOwn, and ChTime

	See edv_purge_obj.h and edv_recover_obj.h for recycled
	object purge and recover.
 */

#ifndef EDV_RECYCLED_OBJ_OP_H
#define EDV_RECYCLED_OBJ_OP_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern const gchar *edv_recycled_object_op_get_error(EDVCore *core);

extern gint edv_recycled_object_op_relink(
	EDVCore *core,
	const gulong index,
	const gchar *new_target,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_recycled_object_op_rename(
	EDVCore *core,
	const gulong index,
	const gchar *new_name,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_recycled_object_op_chmod(
	EDVCore *core,
	GList *indices_list,
	const EDVPermissionFlags permissions,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_recycled_object_op_chown(
	EDVCore *core,
	GList *indicies_list,
	const gint owner_id, const gint group_id,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_recycled_object_op_chtime(
	EDVCore *core,
	GList *indicies_list,
	const gulong atime, const gulong mtime, const gulong dtime,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);


#endif	/* EDV_RECYCLED_OBJ_OP_H */
