/*
                   Endeavour Mark II - Recycle Bin Sync

	Compacts the recycled objects and fixes errors in the Recycle
	Bin.
 */

#ifndef EDV_RECYCLE_BIN_SYNC_H
#define EDV_RECYCLE_BIN_SYNC_H

#include <gtk/gtk.h>

#include "edv_types.h"
#include "libendeavour2-base/edv_recycled_obj.h"


extern const gchar *edv_recycle_bin_sync_get_error(EDVCore *core);

extern gint edv_recycle_bin_sync(
	EDVCore *core,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all,
	void (*status_message_cb)(
		GtkWidget *,			/* NULL */
		const gchar *,			/* Message */
		gpointer			/* status_message_data */
	),
	gpointer status_message_data,
	void (*status_progress_cb)(
		GtkWidget *,			/* NULL */
		gfloat,				/* Progress */
		gpointer			/* status_progress_data */
	),
	gpointer status_progress_data
);


#endif	/* EDV_RECYCLE_BIN_SYNC_H */
