/*
                   Endeavour Mark II - Purge Recycled Object

	High-level purge recycled object from the recycle bin.
 */

#ifndef EDV_PURGE_OBJ_H
#define EDV_PURGE_OBJ_H

#include <gtk/gtk.h>

#include "edv_types.h"
#include "libendeavour2-base/edv_recycled_obj.h"


extern const gchar *edv_purge_object_get_error(EDVCore *core);

extern gint edv_purge_object(
	EDVCore *core,
	const gulong index,
	GtkWidget *toplevel,
	const gfloat progress_value,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint edv_purge_all_objects(
	EDVCore *core,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);


#endif	/* EDV_PURGE_OBJ_H */
