#ifndef EDV_PROGRESS_H
#define EDV_PROGRESS_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "edv_types.h"


/* VFS Operations */
extern void edv_progress_dialog_map_move_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);
extern void edv_progress_dialog_map_copy_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);
extern void edv_progress_dialog_map_delete_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap,
	const EDVDeleteMethod delete_method
);
extern void edv_progress_dialog_map_recover_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);
extern void edv_progress_dialog_map_purge_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);

/* Archive Operations */
extern void edv_progress_dialog_map_archive_add_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);
extern void edv_progress_dialog_map_archive_extract_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);
extern void edv_progress_dialog_map_archive_delete_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);
extern void edv_progress_dialog_map_archive_fix_animated(
        CfgList *cfg_list,
	const gchar *label,
	const gfloat progress,
	GtkWidget *toplevel,
	const gboolean force_remap
);


#endif	/* EDV_PROGRESS_H */
